/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.commands;

import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

public class UpdateLifelineRepresentsCommand
extends AbstractCommand {
    private final Lifeline lifeline;
    private final Classifier classifier;
    private boolean createProperty;
    private boolean createConnectorEnd;
    private ConnectableElement newProperty;
    private ConnectorEnd connectorend;
    private ConnectableElement oldProperty;
    private final EditingDomain editingDomain;

    public boolean canExecute() {
        return true;
    }

    public UpdateLifelineRepresentsCommand(Lifeline lifeline, Classifier classifier, EditingDomain domain) {
        this.lifeline = lifeline;
        this.classifier = classifier;
        this.editingDomain = domain;
        this.label = "Updates the Classifier that represents and Lifeline";
        this.isExecutable = true;
        this.isPrepared = true;
    }

    protected ConnectorEnd getConnectorEnd(Interaction interaction, ConnectableElement prop) {
        EList connectors = interaction.getOwnedConnectors();
        if (connectors.isEmpty()) {
            Connector connector = interaction.createOwnedConnector(null);
            return null;
        }
        Iterator itconnectors = connectors.iterator();
        ConnectorEnd end = null;
        while (end == null && itconnectors.hasNext()) {
            Iterator itends = ((Connector)itconnectors.next()).getEnds().iterator();
            while (end == null && itends.hasNext()) {
                ConnectorEnd e = (ConnectorEnd)itends.next();
                if (e.getRole() != prop) continue;
                end = e;
            }
        }
        return end;
    }

    public void execute() {
        this.oldProperty = this.lifeline.getRepresents();
        this.redo();
    }

    public void redo() {
        if (this.classifier == null) {
            this.deleteAuxElements();
            this.createProperty = false;
            this.createConnectorEnd = false;
            return;
        }
        if (this.lifeline.getRepresents() != null) {
            this.deleteAuxElements();
        }
        Interaction interaction = this.lifeline.getInteraction();
        this.newProperty = interaction.getOwnedAttribute(null, (Type)this.classifier);
        boolean bl = this.createProperty = this.newProperty == null;
        if (this.createProperty) {
            this.newProperty = interaction.createOwnedAttribute(null, (Type)this.classifier);
        }
        this.connectorend = this.getConnectorEnd(interaction, this.newProperty);
        boolean bl2 = this.createConnectorEnd = this.connectorend == null;
        if (this.createConnectorEnd) {
            this.connectorend = ((Connector)interaction.getOwnedConnectors().get(0)).createEnd();
            this.connectorend.setRole(this.newProperty);
        }
        this.lifeline.setRepresents(this.newProperty);
    }

    private void deleteAuxElements() {
        ConnectableElement connectElem = this.lifeline.getRepresents();
        this.lifeline.setRepresents(null);
        this.removeIfNotReferenced(connectElem);
    }

    private void removeIfNotReferenced(ConnectableElement connectElem) {
        Connector connector;
        Interaction interaction = this.lifeline.getInteraction();
        if (interaction.getOwnedConnectors().size() > 0 && (connector = (Connector)interaction.getOwnedConnectors().get(0)) != null) {
            for (ConnectorEnd cEnd : connector.getEnds()) {
                if (!cEnd.getRole().equals(connectElem)) continue;
                connectElem.destroy();
                cEnd.destroy();
                return;
            }
        }
    }

    public void undo() {
        if (this.createConnectorEnd) {
            this.connectorend.setRole(null);
            ((Connector)this.connectorend.getOwner()).getEnds().remove((Object)this.connectorend);
        }
        if (this.createProperty) {
            ((StructuredClassifier)this.newProperty.getOwner()).getOwnedAttributes().remove((Object)this.newProperty);
        }
        this.lifeline.setRepresents(this.oldProperty);
    }
}

