/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.dragtracker;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;

public class NoScrollDragEditPartsTrackerEx
extends DragEditPartsTrackerEx {
    public NoScrollDragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected void updateTargetRequest() {
        int BORDER = 5;
        super.updateTargetRequest();
        Dimension delta = this.getDragMoveDelta();
        if (this.getSourceEditPart() instanceof GraphicalEditPart) {
            Rectangle childRect = ((GraphicalEditPart)this.getSourceEditPart()).getFigure().getBounds();
            if (this.getSourceEditPart().getParent() instanceof GraphicalEditPart) {
                IFigure parentFigure = ((GraphicalEditPart)this.getSourceEditPart().getParent()).getFigure();
                Rectangle parentRect = parentFigure.getBounds();
                if (parentFigure instanceof ShapeCompartmentFigure) {
                    parentRect = ((ShapeCompartmentFigure)parentFigure).getContentPane().getBounds();
                }
                GraphicalEditPart ParentEditPart = (GraphicalEditPart)this.getSourceEditPart().getParent();
                Rectangle virtualPosition = childRect.getCopy();
                virtualPosition.x += delta.width;
                virtualPosition.y += delta.height;
                if (virtualPosition.x < 0) {
                    delta.width = 0 - childRect.x;
                }
                if (virtualPosition.y < 0) {
                    delta.height = 0 - childRect.y;
                }
                if (virtualPosition.x + virtualPosition.width + BORDER > parentRect.width) {
                    delta.width = parentRect.width - childRect.width - childRect.x - BORDER;
                }
                if (virtualPosition.y + virtualPosition.height + BORDER > parentRect.height) {
                    delta.height = parentRect.height - childRect.height - childRect.y - BORDER;
                }
                ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
                Point moveDelta = new Point(delta.width, delta.height);
                request.setMoveDelta(moveDelta);
                this.setTargetEditPart(this.getSourceEditPart().getParent());
            }
        }
    }
}

