/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.dragtracker;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;

public class NoScrollResizeTracker
extends ResizeTracker {
    public NoScrollResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected void updateSourceRequest() {
        int BORDER = 5;
        super.updateSourceRequest();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension deltaResize = request.getSizeDelta();
        Point delta = request.getMoveDelta();
        if (this.getOwner() instanceof GraphicalEditPart) {
            Rectangle childRect = this.getOwner().getFigure().getBounds();
            if (this.getOwner().getParent() instanceof GraphicalEditPart) {
                IFigure parentFigure = ((GraphicalEditPart)this.getOwner().getParent()).getFigure();
                Point originLimit = childRect.getBottomRight();
                Rectangle parentRect = parentFigure.getBounds();
                if (parentFigure instanceof ShapeCompartmentFigure) {
                    parentRect = ((ShapeCompartmentFigure)parentFigure).getContentPane().getBounds();
                }
                Rectangle virtualPosition = childRect.getCopy();
                virtualPosition.x += delta.x;
                virtualPosition.y += delta.y;
                virtualPosition.width += deltaResize.width;
                virtualPosition.height += deltaResize.height;
                if (virtualPosition.x < 0) {
                    delta.x = 0 - childRect.x;
                    deltaResize.width = Math.abs(delta.x);
                }
                if (virtualPosition.y < 0) {
                    delta.y = 0 - childRect.y;
                    deltaResize.height = Math.abs(delta.y);
                }
                if (virtualPosition.getBottomRight().x > parentRect.width - BORDER) {
                    deltaResize.width = parentRect.width - childRect.getBottomRight().x - BORDER;
                }
                if (virtualPosition.getBottomRight().y > parentRect.height - BORDER) {
                    deltaResize.height = parentRect.height - childRect.getBottomRight().y - BORDER;
                }
                if (virtualPosition.x > originLimit.x - this.getOwner().getFigure().getMinimumSize((int)0, (int)0).width) {
                    delta.x = this.getOwner().getFigure().getBounds().width - this.getOwner().getFigure().getMinimumSize((int)0, (int)0).width;
                    deltaResize.width = this.getOwner().getFigure().getMinimumSize((int)0, (int)0).width - this.getOwner().getFigure().getBounds().width;
                }
                if (virtualPosition.y > originLimit.y - this.getOwner().getFigure().getMinimumSize((int)0, (int)0).height) {
                    delta.y = this.getOwner().getFigure().getBounds().height - this.getOwner().getFigure().getMinimumSize((int)0, (int)0).height;
                    deltaResize.height = this.getOwner().getFigure().getMinimumSize((int)0, (int)0).height - this.getOwner().getFigure().getBounds().height;
                }
                request.setMoveDelta(delta);
            }
        }
    }
}

