/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.draw2d;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class CenterLayout
extends StackLayout {
    private static final Rectangle RECTANGLE = new Rectangle();

    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        int centerX = r.x + r.width / 2;
        int centerY = r.y + r.height / 2;
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension prefSize = child.getPreferredSize(r.width, r.height);
            CenterLayout.RECTANGLE.x = centerX - prefSize.width / 2;
            CenterLayout.RECTANGLE.y = centerY - prefSize.height / 2;
            CenterLayout.RECTANGLE.width = prefSize.width;
            CenterLayout.RECTANGLE.height = prefSize.height;
            child.setBounds(RECTANGLE);
            ++i;
        }
    }
}

