/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;

public class InteractionFigure
extends Shape {
    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle r = this.getBounds();
        int labelWidth = -1;
        for (Object obj : this.getChildren()) {
            if (!(obj instanceof WrappingLabel) && !(obj instanceof WrapLabel)) continue;
            WrappingLabel wLabel = (WrappingLabel)obj;
            labelWidth = wLabel.getPreferredSize().width;
        }
        if (labelWidth <= 0) {
            labelWidth = r.width / 4;
        }
        PointList points = new PointList();
        Point verticalStart = new Point();
        Point verticalEnd = new Point();
        Point diagonalStart = new Point();
        Point diagonalEnd = new Point();
        Point horizontalStart = new Point();
        Point horizontalEnd = new Point();
        verticalStart.x = r.x + labelWidth + 4;
        verticalStart.y = r.y;
        points.addPoint(verticalStart);
        verticalEnd.x = verticalStart.x;
        verticalEnd.y = verticalStart.y + r.height / 2 + 3;
        points.addPoint(verticalEnd);
        diagonalStart.x = verticalEnd.x;
        diagonalStart.y = verticalEnd.y;
        points.addPoint(diagonalStart);
        diagonalEnd.x = diagonalStart.x - r.height / 2 + 3;
        diagonalEnd.y = r.y + r.height - 1;
        points.addPoint(diagonalEnd);
        horizontalStart.x = diagonalEnd.x;
        horizontalStart.y = diagonalEnd.y;
        points.addPoint(horizontalStart);
        horizontalEnd.x = r.x;
        horizontalEnd.y = horizontalStart.y;
        points.addPoint(horizontalEnd);
        graphics.drawPolyline(points);
    }
}

