/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class LinesBorder
extends LineBorder {
    private int positions = 0;
    private int leftInset = 0;
    private int rightInset = 0;
    private int topInset = 0;
    private int bottomInset = 0;

    public LinesBorder() {
        this(1, 0);
    }

    public LinesBorder(int sides) {
        this(1, sides);
    }

    public LinesBorder(int width, int sides) {
        super(width);
        this.positions = sides;
    }

    public int getSides() {
        return this.positions;
    }

    public void setSides(int sides) {
        this.positions = sides;
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.getTopInset(), this.getLeftInset(), this.getBottomInset(), this.getRightInset());
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(LinesBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        int one = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(1);
        int widthInDP = this.getWidth() / one;
        int halfWidthInLP = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(widthInDP / 2);
        graphics.setLineWidth(this.getWidth());
        graphics.setLineStyle(this.getStyle());
        LinesBorder.tempRect.x += halfWidthInLP;
        LinesBorder.tempRect.width -= this.getWidth();
        LinesBorder.tempRect.y += halfWidthInLP;
        LinesBorder.tempRect.height -= this.getWidth();
        if ((this.positions & 8) > 0) {
            graphics.drawLine(tempRect.getTopLeft(), tempRect.getTopRight());
        }
        if ((this.positions & 1) > 0) {
            graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomLeft());
        }
        if ((this.positions & 0x20) > 0) {
            graphics.drawLine(tempRect.getBottomLeft(), tempRect.getBottomRight());
        }
        if ((this.positions & 4) > 0) {
            graphics.drawLine(tempRect.getTopRight(), tempRect.getBottomRight());
        }
    }

    public int getPositions() {
        return this.positions;
    }

    public void setPositions(int positions) {
        this.positions = positions;
    }

    public int getLeftInset() {
        if (this.leftInset < this.getWidth() && (this.positions & 1) > 0) {
            return this.getWidth();
        }
        return this.leftInset;
    }

    public void setLeftInset(int leftInset) {
        this.leftInset = leftInset;
    }

    public int getRightInset() {
        if (this.rightInset < this.getWidth() && (this.positions & 4) > 0) {
            return this.getWidth();
        }
        return this.rightInset;
    }

    public void setRightInset(int rightInset) {
        this.rightInset = rightInset;
    }

    public int getTopInset() {
        if (this.topInset < this.getWidth() && (this.positions & 8) > 0) {
            return this.getWidth();
        }
        return this.topInset;
    }

    public void setTopInset(int topInset) {
        this.topInset = topInset;
    }

    public int getBottomInset() {
        if (this.bottomInset < this.getWidth() && (this.positions & 8) > 0) {
            return this.getWidth();
        }
        return this.bottomInset;
    }

    public void setBottomInset(int bottomInset) {
        this.bottomInset = bottomInset;
    }
}

