/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.draw2d;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class PileLayout
extends AbstractHintLayout {
    private int myGap;
    private Map<IFigure, Object> myConstraints = new HashMap<IFigure, Object>(2);
    private boolean myStretchBottom;
    private static final SizeExtractor MIN_SIZE_EXTRACTOR = new SizeExtractor(){

        public Dimension getSize(IFigure figure, int wHint, int hHint) {
            return figure.getMinimumSize(wHint, hHint);
        }
    };
    private static final SizeExtractor PREF_SIZE_EXTRACTOR = new SizeExtractor(){

        public Dimension getSize(IFigure figure, int wHint, int hHint) {
            return figure.getPreferredSize(wHint, hHint);
        }
    };
    public static final PileConstraint FILL = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds) {
        }
    };
    public static final PileConstraint ALIGN_LEFT = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds) {
            bounds.width = Math.min(preferred.width, bounds.width);
        }
    };
    public static final PileConstraint ALIGN_CENTER = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds) {
            if (bounds.width > preferred.width) {
                int offset = (bounds.width - preferred.width) / 2;
                bounds.x += offset;
                bounds.width = preferred.width;
            }
        }
    };
    public static final PileConstraint ALIGN_RIGHT = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds) {
            if (bounds.width > preferred.width) {
                bounds.x += bounds.width - preferred.width;
                bounds.width = preferred.width;
            }
        }
    };

    public final int getGap() {
        return this.myGap;
    }

    public void setGap(int gap) {
        this.myGap = gap > 0 ? gap : 0;
    }

    public void setNegativeGap(int gap) {
        this.myGap = gap;
    }

    public final boolean isStretchBottom() {
        return this.myStretchBottom;
    }

    public void setStretchBottom(boolean stretchBottom) {
        this.myStretchBottom = stretchBottom;
    }

    public void remove(IFigure figure) {
        this.myConstraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        if (constraint == null) {
            this.remove(figure);
        } else {
            this.myConstraints.put(figure, constraint);
        }
    }

    public Object getConstraint(IFigure figure) {
        return this.myConstraints.get(figure);
    }

    protected PileConstraint getPileConstraint(IFigure figure) {
        Object constraint = this.getConstraint(figure);
        return constraint instanceof PileConstraint ? (PileConstraint)constraint : FILL;
    }

    protected Dimension calculateSize(IFigure container, int wHint, int hHint, SizeExtractor sizeExtractor) {
        int totalWidth = 0;
        int totalHeight = 0;
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension size = sizeExtractor.getSize(child, wHint, hHint);
            if (totalWidth < size.width) {
                totalWidth = size.width;
            }
            totalHeight += size.height + this.getGap();
            ++i;
        }
        totalHeight -= this.getGap();
        Insets insets = container.getInsets();
        return new Dimension(totalWidth += insets.getWidth(), totalHeight += insets.getHeight());
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        return this.calculateSize(container, wHint, hHint, MIN_SIZE_EXTRACTOR);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return this.calculateSize(container, wHint, hHint, PREF_SIZE_EXTRACTOR);
    }

    public void layout(IFigure container) {
        Rectangle clientArea = container.getClientArea();
        int y = clientArea.y;
        int maxY = clientArea.y + clientArea.height;
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            Rectangle bounds;
            IFigure child = (IFigure)children.get(i);
            Dimension preferred = child.getPreferredSize(clientArea.width, clientArea.height);
            int height = preferred.height;
            if (y >= maxY) {
                bounds = new Rectangle(clientArea.x, maxY, clientArea.width, 0);
                child.setBounds(bounds);
            } else {
                if (y + height > maxY || this.isStretchBottom() && i == children.size() - 1) {
                    height = maxY - y;
                }
                bounds = new Rectangle(clientArea.x, y, clientArea.width, height);
                this.getPileConstraint(child).setChildBounds(preferred, bounds);
                child.setBounds(bounds);
                y += bounds.height + this.getGap();
            }
            ++i;
        }
    }

    public static interface PileConstraint {
        public void setChildBounds(Dimension var1, Rectangle var2);
    }

    private static interface SizeExtractor {
        public Dimension getSize(IFigure var1, int var2, int var3);
    }
}

