/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editparts;

import java.net.MalformedURLException;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.editparts.IPapyrusEditPart;
import org.eclipse.papyrus.diagram.common.figure.node.ShapeNamedElementFigure;
import org.eclipse.papyrus.umlutils.ElementUtil;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AbstractShapeEditPart
extends AbstractBorderedShapeEditPart
implements IPapyrusEditPart {
    private static final String SHAPE_CONSTANT = "shape";
    private IPageIconsRegistry editorRegistry;

    public AbstractShapeEditPart(View view) {
        super(view);
    }

    protected NodeFigure createMainFigure() {
        return null;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
        catch (NullPointerException e) {
            return new PageIconsRegistry();
        }
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    public abstract ShapeNamedElementFigure getPrimaryShape();

    public void refresh() {
        this.refreshIcons();
        super.refresh();
    }

    protected Element getUMLElement() {
        return (Element)this.resolveSemanticElement();
    }

    private void refreshIcons() {
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getModel()));
        StringTokenizer tokenizer = new StringTokenizer(stereotypesToDisplay, ",");
        if (tokenizer.hasMoreTokens()) {
            String firstStereotypeName = tokenizer.nextToken();
            Stereotype stereotype = this.getUMLElement().getAppliedStereotype(firstStereotypeName);
            Image icon = ElementUtil.getStereotypeImage((Element)this.getUMLElement(), (Stereotype)stereotype, (String)SHAPE_CONSTANT);
            if (icon != null) {
                if (icon.getLocation() != "" && icon.getLocation() != null) {
                    try {
                        this.getPrimaryShape().setIcon(icon.getLocation());
                    }
                    catch (MalformedURLException e) {
                        Activator.log.error(String.valueOf(icon.getLocation()) + " " + e.getLocalizedMessage(), (Throwable)e);
                    }
                } else {
                    this.getPrimaryShape().setIcon(Activator.getShape(this.getUMLElement(), stereotype, false));
                }
            }
        }
    }
}

