/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editparts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.diagram.common.figure.node.ClassifierFigure;
import org.eclipse.papyrus.diagram.common.helper.BasicClassifierCompartmentLayoutHelper;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class ClassifierEditPart
extends NamedElementEditPart {
    private boolean isAbstract;

    public ClassifierEditPart(View view) {
        super(view);
        this.setCompartmentLayoutHelper(BasicClassifierCompartmentLayoutHelper.getInstances());
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (this.resolveSemanticElement() != null && UMLPackage.eINSTANCE.getClassifier_IsAbstract().equals(feature)) {
            this.isAbstract = notification.getNewBooleanValue();
            this.refreshFont();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getPrimaryShape() != null && this.resolveSemanticElement() != null) {
            this.refreshAbstract();
            this.refreshIsActive();
        }
    }

    protected void refreshIsActive() {
        if (this.getUMLElement() instanceof Class && this.getPrimaryShape() instanceof ClassifierFigure) {
            ((ClassifierFigure)this.getPrimaryShape()).setActive(((Class)this.getUMLElement()).isActive());
        }
    }

    protected void refreshAbstract() {
        if (this.getUMLElement() instanceof Classifier) {
            this.isAbstract = ((Classifier)this.getUMLElement()).isAbstract();
            this.refreshFont();
        }
    }

    protected FontData getFontData(FontStyle style) {
        return new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (this.isAbstract ? 2 : (style.isItalic() ? 2 : 0)));
    }
}

