/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.editpolicies.AbstractAppliedStereotypeDisplayEditPolicy;
import org.eclipse.papyrus.umlutils.StereotypeUtil;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AppliedStereotypeLabelDisplayEditPolicy
extends AbstractAppliedStereotypeDisplayEditPolicy {
    public static final String STEREOTYPE_LABEL_POLICY = "AppliedStereotypeLabelDisplayEditPolicy";
    public String tag;

    public AppliedStereotypeLabelDisplayEditPolicy(String tag) {
        this.tag = String.valueOf(Activator.ST_LEFT) + tag + Activator.ST_RIGHT;
    }

    public AppliedStereotypeLabelDisplayEditPolicy() {
        this.tag = "";
    }

    public void refreshDisplay() {
        this.refreshStereotypeDisplay();
    }

    protected abstract void refreshStereotypeDisplay();

    public Image stereotypeIconToDisplay() {
        String stereotypesToDisplay;
        StringTokenizer tokenizer;
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)this.getHost().getModel()));
        if (stereotypespresentationKind == null) {
            return null;
        }
        if ((stereotypespresentationKind.equals("IconStereotype") || stereotypespresentationKind.equals("TextIconStereotype")) && (tokenizer = new StringTokenizer(stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getHost().getModel())), ",")).hasMoreTokens()) {
            String firstStereotypeName = tokenizer.nextToken();
            Stereotype stereotype = this.getUMLElement().getAppliedStereotype(firstStereotypeName);
            return Activator.getIconElement(this.getUMLElement(), stereotype, false);
        }
        return null;
    }

    public String stereotypesAndPropertiesToDisplay(String separator, String stereotypesToDisplay, String stereotypeWithQualifiedName, String stereotypesPropertiesToDisplay) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        assert (store != null) : "The preference store was not found";
        if (store == null) {
            return "";
        }
        String sNameAppearance = store.getString("ProfileApplicationPreferenceConstants.stereotype.name.appearance");
        Map<String, List<String>> propertiesToDisplay = this.parseStereotypeProperties(stereotypesToDisplay, stereotypesPropertiesToDisplay);
        StringTokenizer strQualifiedName = new StringTokenizer(stereotypesToDisplay, ",");
        String out = "";
        while (strQualifiedName.hasMoreElements()) {
            List<String> properties;
            String currentStereotype = strQualifiedName.nextToken();
            Element umlElement = this.getUMLElement();
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype == null) continue;
            String name = currentStereotype;
            if (stereotypeWithQualifiedName.indexOf(currentStereotype) == -1) {
                StringTokenizer strToken = new StringTokenizer(currentStereotype, "::");
                while (strToken.hasMoreTokens()) {
                    name = strToken.nextToken();
                }
            }
            if (sNameAppearance.equals("User Controlled")) {
                if (out.indexOf(name) == -1) {
                    out = String.valueOf(out) + Activator.ST_LEFT + name + Activator.ST_RIGHT + separator;
                }
            } else if (out.indexOf(name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length())) == -1) {
                out = String.valueOf(out) + Activator.ST_LEFT + name + Activator.ST_RIGHT + separator;
            }
            if ((properties = propertiesToDisplay.get(stereotype.getQualifiedName())) == null) continue;
            for (String propertyName : properties) {
                out = String.valueOf(out) + StereotypeUtil.displayPropertyValue((Stereotype)stereotype, (Property)StereotypeUtil.getPropertyByName((Stereotype)stereotype, (String)propertyName), (Element)this.getUMLElement(), (String)"\n");
            }
        }
        if (out.endsWith(",")) {
            return out.substring(0, out.length() - 1);
        }
        if (out.endsWith(separator)) {
            return out.substring(0, out.length() - separator.length());
        }
        return out;
    }

    public String stereotypesToDisplay() {
        String stereotypesPropertiesToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()));
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getHost().getModel()));
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)this.getHost().getModel()));
        if ("IconStereotype".equals(stereotypespresentationKind)) {
            return StereotypeUtil.getPropertiesValuesInBrace((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement());
        }
        String stereotypesToDisplayWithQN = AppliedStereotypeHelper.getStereotypesQNToDisplay((EModelElement)((View)this.getHost().getModel()));
        String display = "";
        if ("VerticalStereo".equals(stereotypespresentationKind)) {
            display = String.valueOf(display) + this.stereotypesAndPropertiesToDisplay("\n", stereotypesToDisplay, stereotypesToDisplayWithQN, stereotypesPropertiesToDisplay);
        } else {
            String propSt;
            String st = this.stereotypesToDisplay(", ", stereotypesToDisplay, stereotypesToDisplayWithQN);
            if (st != null && !st.equals("")) {
                display = String.valueOf(display) + Activator.ST_LEFT + st + Activator.ST_RIGHT;
            }
            if ((propSt = StereotypeUtil.getPropertiesValuesInBrace((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement())) != null && !propSt.equals("")) {
                if (st != null && !st.equals("")) {
                    display = String.valueOf(display) + "\n";
                }
                display = String.valueOf(display) + "{" + propSt + "}";
            }
        }
        return display;
    }

    public String stereotypesToDisplay(String separator, String stereotypesToDisplay, String stereotypeWithQualifiedName) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        assert (store != null) : "The preference store was not found";
        if (store == null) {
            return "";
        }
        String sNameAppearance = store.getString("ProfileApplicationPreferenceConstants.stereotype.name.appearance");
        StringTokenizer strQualifiedName = new StringTokenizer(stereotypesToDisplay, ",");
        String out = "";
        while (strQualifiedName.hasMoreElements()) {
            String currentStereotype = strQualifiedName.nextToken();
            Element umlElement = this.getUMLElement();
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype == null) continue;
            String name = currentStereotype;
            if (stereotypeWithQualifiedName.indexOf(currentStereotype) == -1) {
                StringTokenizer strToken = new StringTokenizer(currentStereotype, "::");
                while (strToken.hasMoreTokens()) {
                    name = strToken.nextToken();
                }
            }
            if (sNameAppearance.equals("User Controlled")) {
                if (out.indexOf(name) != -1) continue;
                out = String.valueOf(out) + name + separator;
                continue;
            }
            if (out.indexOf(name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length())) != -1) continue;
            out = String.valueOf(out) + name + separator;
        }
        if (out.endsWith(",")) {
            return out.substring(0, out.length() - 1);
        }
        if (out.endsWith(separator)) {
            return out.substring(0, out.length() - separator.length());
        }
        return out;
    }
}

