/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.editparts.IPapyrusEditPart;
import org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLabelDisplayEditPolicy;
import org.eclipse.papyrus.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.umlutils.StereotypeUtil;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;

public class AppliedStereotypeNodeLabelDisplayEditPolicy
extends AppliedStereotypeLabelDisplayEditPolicy {
    public AppliedStereotypeNodeLabelDisplayEditPolicy() {
    }

    public AppliedStereotypeNodeLabelDisplayEditPolicy(String tag) {
        super(tag);
    }

    protected void refreshStereotypeDisplay() {
        if (this.getHost() instanceof IPapyrusEditPart) {
            IFigure figure = ((IPapyrusEditPart)this.getHost()).getPrimaryShape();
            String stereotypesToDisplay = this.stereotypesOnlyToDisplay();
            Image imageToDisplay = this.stereotypeIconToDisplay();
            if (figure instanceof IPapyrusNodeUMLElementFigure) {
                ((IPapyrusNodeUMLElementFigure)figure).setStereotypeDisplay(String.valueOf(this.tag) + (this.stereotypesOnlyToDisplay().equals("") ? stereotypesToDisplay : stereotypesToDisplay), imageToDisplay);
                this.refreshAppliedStereotypesProperties((IPapyrusNodeUMLElementFigure)figure);
            }
        }
    }

    protected void refreshAppliedStereotypesProperties(IPapyrusNodeUMLElementFigure figure) {
        String stereotypesPropertiesToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()));
        this.refreshAppliedStereotypesPropertiesInCompartment(stereotypesPropertiesToDisplay, figure);
        this.refreshAppliedStereotypesPropertiesInBrace(stereotypesPropertiesToDisplay, figure);
    }

    protected void refreshAppliedStereotypesPropertiesInCompartment(String stereotypesPropertiesToDisplay, IPapyrusNodeUMLElementFigure figure) {
        boolean displayInCompartment = AppliedStereotypeHelper.hasAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()), (String)"Compartment");
        if (displayInCompartment) {
            String todisplay = StereotypeUtil.getPropertiesValues((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement());
            figure.setStereotypePropertiesInCompartment(todisplay);
        } else {
            figure.setStereotypePropertiesInCompartment(null);
        }
    }

    protected void refreshAppliedStereotypesPropertiesInBrace(String stereotypesPropertiesToDisplay, IPapyrusNodeUMLElementFigure figure) {
        boolean displayInBrace = AppliedStereotypeHelper.hasAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()), (String)"With brace");
        if (displayInBrace) {
            String todisplay = StereotypeUtil.getPropertiesValuesInBrace((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement());
            figure.setStereotypePropertiesInBrace(todisplay);
        } else {
            figure.setStereotypePropertiesInBrace(null);
        }
    }

    public String stereotypesOnlyToDisplay() {
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getHost().getModel()));
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)this.getHost().getModel()));
        if ("IconStereotype".equals(stereotypespresentationKind)) {
            return "";
        }
        String stereotypesToDisplayWithQN = AppliedStereotypeHelper.getStereotypesQNToDisplay((EModelElement)((View)this.getHost().getModel()));
        if (stereotypesToDisplayWithQN.length() == 0 && stereotypesToDisplay.length() == 0) {
            return "";
        }
        if ("VerticalStereo".equals(stereotypespresentationKind)) {
            return String.valueOf(Activator.ST_LEFT) + this.stereotypesToDisplay(String.valueOf(Activator.ST_RIGHT) + "\n" + Activator.ST_LEFT, stereotypesToDisplay, stereotypesToDisplayWithQN) + Activator.ST_RIGHT;
        }
        return String.valueOf(Activator.ST_LEFT) + this.stereotypesToDisplay(", ", stereotypesToDisplay, stereotypesToDisplayWithQN) + Activator.ST_RIGHT;
    }
}

