/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.core.utils.PapyrusTrace;
import org.eclipse.papyrus.diagram.common.commands.DefferedAppliedStereotypeToDisplayCommand;
import org.eclipse.papyrus.diagram.common.editparts.IUMLEditPart;
import org.eclipse.papyrus.diagram.common.helper.NamedElementHelper;
import org.eclipse.papyrus.diagram.common.service.ApplyStereotypeRequest;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class ApplyStereotypeEditPolicy
extends AbstractEditPolicy {
    public org.eclipse.gef.commands.Command getCommand(Request request) {
        if (this.understandsRequest(request)) {
            this.executeCommand(this.getApplyStereotypeCommand((ApplyStereotypeRequest)request));
            return null;
        }
        return super.getCommand(request);
    }

    public boolean understandsRequest(Request req) {
        if (ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST.equals(req.getType())) {
            return true;
        }
        return super.understandsRequest(req);
    }

    protected void executeCommand(final org.eclipse.gef.commands.Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"executeCommand", (Throwable)e);
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"executeCommand", (Throwable)e);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.understandsRequest(request)) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }

    protected org.eclipse.gef.commands.Command getApplyStereotypeCommand(ApplyStereotypeRequest request) {
        final ApplyStereotypeRequest _request = request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, "Apply Stereotype");
        final ArrayList result = new ArrayList();
        final Element element = (Element)((View)this.getHost().getModel()).getElement();
        cc.compose((IUndoableOperation)new AbstractTransactionalCommand(editingDomain, "Apply Stereotype", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (ApplyStereotypeEditPolicy.this.getHost() instanceof IUMLEditPart || ApplyStereotypeEditPolicy.this.getHost().getModel() instanceof View && ((View)ApplyStereotypeEditPolicy.this.getHost().getModel()).getElement() instanceof Element) {
                    if (element == null) {
                        return null;
                    }
                    List<String> stereotypeQNames = _request.getStereotypesToApply();
                    for (String stereotypeQName : stereotypeQNames) {
                        Stereotype stereotype = element.getApplicableStereotype(stereotypeQName);
                        if (stereotype == null) {
                            PapyrusTrace.log((int)2, (String)("impossible to retrieve the stereotype " + stereotypeQName));
                            continue;
                        }
                        result.add(element.applyStereotype(stereotype));
                    }
                }
                return CommandResult.newOKCommandResult((Object)result);
            }
        });
        Object newName = request.getExtendedData().get(ApplyStereotypeRequest.NEW_EDIT_PART_NAME);
        if (newName != null) {
            cc.compose((IUndoableOperation)new AbstractTransactionalCommand(editingDomain, "Edit Base Element Name", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (ApplyStereotypeEditPolicy.this.getHost() instanceof IUMLEditPart || ApplyStereotypeEditPolicy.this.getHost().getModel() instanceof View && ((View)ApplyStereotypeEditPolicy.this.getHost().getModel()).getElement() instanceof Element) {
                        if (!(element instanceof NamedElement)) {
                            return null;
                        }
                        List<String> stereotypeQNames = _request.getStereotypesToApply();
                        String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQNames.get(0));
                        String name = NamedElementHelper.EINSTANCE.getNewUMLElementName(element.getOwner(), stereotypeName);
                        ((NamedElement)element).setName(name);
                    }
                    return CommandResult.newOKCommandResult((Object)result);
                }
            });
        }
        String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)element);
        cc.compose((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)new DefferedAppliedStereotypeToDisplayCommand(editingDomain, (IAdaptable)this.getHost(), "", presentationKind)));
        return new ICommandProxy(cc.reduce());
    }

    public String getStereotypeList(ApplyStereotypeRequest request) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> it = request.getStereotypesToApply().iterator();
        while (it.hasNext()) {
            String stereotypeQN = it.next();
            buffer.append(stereotypeQN);
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

