/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.diagram.common.editparts.AbstractShapeEditPart;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeStereotypedShapeEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String CHANGE_SHAPE_POLICY = "CHANGE_SHAPE_POLICY";
    protected Element hostSemanticElement;

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected Element getUMLElement() {
        if (this.getView().getElement() instanceof Element) {
            return (Element)this.getView().getElement();
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    public ArrayList<EObject> getAllSemanticLink(GraphicalEditPart gmfpart) {
        ArrayList<EObject> elementToDrop = new ArrayList<EObject>();
        for (Edge edge : gmfpart.getNotationView().getSourceEdges()) {
            if (edge.getElement() == null) continue;
            elementToDrop.add(edge.getElement());
        }
        for (Edge edge : gmfpart.getNotationView().getTargetEdges()) {
            if (edge.getElement() == null) continue;
            elementToDrop.add(edge.getElement());
        }
        return elementToDrop;
    }

    public void dropLink(GraphicalEditPart gmfparent, ArrayList<EObject> elementToDrop) {
        for (EObject currentObject : elementToDrop) {
            DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
            ArrayList<Element> list = new ArrayList<Element>();
            list.add((Element)currentObject);
            dropObjectsRequest.setObjects(list);
            dropObjectsRequest.setLocation(new Point(0, 0));
            Command cmd = gmfparent.getCommand((Request)dropObjectsRequest);
            gmfparent.getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNotifier()).getSource()) {
            if (!(this.getHost() instanceof AbstractShapeEditPart) && AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.getView()) == "ImageStereotype" && notification.getNewValue() instanceof Map.Entry && ((Map.Entry)notification.getNewValue()).getKey().equals("Stereotype_Presentation_Kind")) {
                this.transformIntoShape(this.getHost());
            }
            if (this.getHost() instanceof AbstractShapeEditPart && AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.getView()) != "ImageStereotype" && notification.getNewValue() instanceof Map.Entry && ((Map.Entry)notification.getNewValue()).getKey().equals("Stereotype_Presentation_Kind")) {
                this.transformIntoNormalShape(this.getHost());
            }
        }
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.getUMLElement();
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().addNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().removeNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        this.hostSemanticElement = null;
    }

    public abstract void transformIntoShape(EditPart var1);

    public abstract void transformIntoNormalShape(EditPart var1);
}

