/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.diagram.common.directedit.FigureControler;
import org.eclipse.papyrus.diagram.common.directedit.PropertyAccessor;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;

public class ExtendedDirectEditPolicy
extends LabelDirectEditPolicy {
    protected int directEditionMode = 0;
    private IDirectEditorConfiguration configuration;
    protected DirectEditManager manager;

    protected Command getDirectEditCommand(DirectEditRequest request) {
        return this.performDirectEdit(request);
    }

    public Command performDirectEdit(DirectEditRequest req) {
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return null;
            }
            case 4: {
                this.configuration.preEditAction((Object)this.getUMLElement());
                final ExtendedDirectEditionDialog dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.getUMLElement(), this.configuration.getTextToEdit((Object)this.getUMLElement()), this.configuration);
                if (dialog.open() == 0) {
                    TransactionalEditingDomain domain = this.getEditingDomain();
                    try {
                        domain.runExclusive((Runnable)new RunnableWithResult(){
                            private Object result = null;
                            private IStatus status = Status.OK_STATUS;

                            public Object getResult() {
                                return this.result;
                            }

                            public IStatus getStatus() {
                                return this.status;
                            }

                            public void setStatus(IStatus status) {
                                this.status = status;
                            }

                            public void run() {
                                this.result = ExtendedDirectEditPolicy.this.configuration.postEditAction((Object)ExtendedDirectEditPolicy.this.getUMLElement(), dialog.getValue());
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
            case 2: {
                return super.getDirectEditCommand(req);
            }
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected Element getUMLElement() {
        return (Element)this.getView().getElement();
    }

    public int getDirectEditionType() {
        if (this.checkExtendedEditor()) {
            this.initExtendedEditorConfiguration();
            return 4;
        }
        if (this.checkDefaultEdition()) {
            return 2;
        }
        return 8;
    }

    protected boolean checkExtendedEditor() {
        if (this.getUMLElement() != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((String)"Papyrus UML", (String)this.getUMLElement().eClass().getInstanceClassName());
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getUMLElement() instanceof NamedElement;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (String)this.getUMLElement().eClass().getInstanceClassName());
        }
    }

    protected void initLabelEditManager() {
        if (this.manager == null) {
            CellEditorLocator locator = this.getTextCellEditorLocator();
            PropertyAccessor accessor = new PropertyAccessor(){

                public String getPropertyName() {
                    return "Name";
                }

                public String getValue() {
                    if (ExtendedDirectEditPolicy.this.isElementImport()) {
                        return ExtendedDirectEditPolicy.this.getElementImport().getAlias();
                    }
                    if (ExtendedDirectEditPolicy.this.getUMLElement() instanceof NamedElement) {
                        return ((NamedElement)ExtendedDirectEditPolicy.this.getUMLElement()).getName();
                    }
                    return "";
                }

                public void setValue(String value) {
                    if (ExtendedDirectEditPolicy.this.isElementImport()) {
                        ExtendedDirectEditPolicy.this.getElementImport().setAlias(value);
                    } else if (ExtendedDirectEditPolicy.this.getUMLElement() instanceof NamedElement) {
                        ((NamedElement)ExtendedDirectEditPolicy.this.getUMLElement()).setName(value);
                    }
                }
            };
            FigureControler labelControler = new FigureControler(this.getHostFigure(), accessor);
            this.manager = new TextDirectEditManager((GraphicalEditPart)this.getHost(), TextCellEditorEx.class, locator);
        }
    }

    private CellEditorLocator getTextCellEditorLocator() {
        if (this.getHostFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)this.getHostFigure());
        }
        if (this.getHostFigure() instanceof WrappingLabel) {
            return new LabelCellEditorLocator((Label)this.getHostFigure());
        }
        Activator.log((String)"Problem to locate the direct edit editor. Figure is neither a label nor a wrapping label");
        return null;
    }

    public boolean isElementImport() {
        return this.getUMLElement() instanceof ElementImport;
    }

    public ElementImport getElementImport() {
        if (this.isElementImport()) {
            return (ElementImport)this.getUMLElement();
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    private class LabelCellEditorLocator
    implements CellEditorLocator {
        private final Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private class TextCellEditorLocator
    implements CellEditorLocator {
        private final WrappingLabel wrapLabel;

        public TextCellEditorLocator(WrappingLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrappingLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

