/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.DiagramHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.DocumentHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.EditPartHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.HyperlinkHelperFactory;
import org.eclipse.papyrus.diagram.common.helper.WebHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.AdvancedHLManager;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkLabelProvider;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkManagerShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkPopupBarEditPolicy
extends DiagramAssistantEditPolicy {
    private static Image IMAGE_POPUPBAR_PLUS = DiagramUIPluginImages.get((String)"icons/popupbar_plus.gif");
    private static int POPUPBAR_MOVE_FIGURE = 2;
    private static int POPUPBAR_ONDIAGRAMACTIVATED = 16;
    private IPageIconsRegistry editorRegistry;
    private IFigure figureBar;
    private HyperLinkManagerShell hyperLinkManagerShell;
    protected List<Image> imagesToBeDisposed = new ArrayList<Image>();
    private final PopupBarMouseListener myMouseKeyListener = new PopupBarMouseListener();
    protected ArrayList<HyperlinkObject> hyperLinkObjectList;
    protected HyperlinkHelperFactory hyperlinkHelperFactory;

    public static Package topPackage(Element element) {
        if (element.getOwner() == null) {
            return (Package)element;
        }
        return HyperLinkPopupBarEditPolicy.topPackage(element.getOwner());
    }

    public void activate() {
        super.activate();
    }

    public HyperLinkPopupBarEditPolicy() {
        ArrayList<AbstractHyperLinkHelper> hyperLinkHelpers = new ArrayList<AbstractHyperLinkHelper>();
        hyperLinkHelpers.add(new DiagramHyperLinkHelper());
        hyperLinkHelpers.add(new DocumentHyperLinkHelper());
        hyperLinkHelpers.add(new WebHyperLinkHelper());
        this.hyperlinkHelperFactory = new HyperlinkHelperFactory(hyperLinkHelpers);
    }

    public int addObjectList(int positonwidth, List<?> objectList) {
        int i = 0;
        while (i < objectList.size()) {
            PopupBarLabelHandle handle = null;
            HyperLinkLabelProvider hyperLinkLabelProvider = new HyperLinkLabelProvider(this.getEditorRegistry());
            handle = new PopupBarLabelHandle(this.hyperLinkObjectList.get(i), hyperLinkLabelProvider.getImage(objectList.get(i)));
            Rectangle r1 = new Rectangle();
            r1.setLocation(positonwidth, 5);
            positonwidth += 20;
            r1.setSize(16, 16);
            Label l = new Label();
            l.setText(hyperLinkLabelProvider.getTooltipText(this.hyperLinkObjectList.get(i)));
            handle.setToolTip((IFigure)l);
            handle.setPreferredSize(16, 16);
            handle.setBounds(r1);
            handle.setBackgroundColor(ColorConstants.white);
            this.getFigureBar().add((IFigure)handle);
            handle.addMouseListener((MouseListener)this.myMouseKeyListener);
            handle.addMouseMotionListener((MouseMotionListener)this);
            ++i;
        }
        return positonwidth;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected IFigure createPopupBarFigure() {
        this.figureBar = new RoundedRectangleWithTail();
        return this.figureBar;
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected IFigure getFigureBar() {
        return this.figureBar;
    }

    protected ArrayList<Diagram> getSubDiagrams() {
        Element host = (Element)((GraphicalEditPart)this.getHost()).getNotationView().getElement();
        ArrayList<Diagram> result = new ArrayList<Diagram>();
        if (host != null) {
            try {
                IPageMngr iPageMngr = EditorUtils.getIPageMngr();
                for (Object current : iPageMngr.allPages()) {
                    Element diagElement;
                    if (!(current instanceof Diagram) || !host.equals(diagElement = (Element)((Diagram)current).getElement()) && !host.allOwnedElements().contains((Object)diagElement)) continue;
                    result.add((Diagram)current);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected void hideDiagramAssistant() {
        if (this.getFigureBar() != null) {
            this.getFigureBar().removeMouseMotionListener((MouseMotionListener)this);
            this.getFigureBar().removeMouseListener((MouseListener)this.myMouseKeyListener);
            IFigure layer = this.getLayer("Handle Layer");
            if (this.getFigureBar().getParent() != null) {
                layer.remove(this.getFigureBar());
            }
            if (this.imagesToBeDisposed != null) {
                for (Object current : this.figureBar.getChildren()) {
                    if (!(current instanceof PopupBarLabelHandle)) continue;
                    ((PopupBarLabelHandle)((Object)current)).dispose();
                }
                this.imagesToBeDisposed.clear();
            }
        }
        this.figureBar = null;
    }

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof RoundedRectangleWithTail || object instanceof PopupBarLabelHandle;
    }

    protected boolean isDiagramAssistantShowing() {
        return true;
    }

    protected boolean isPreferenceOn() {
        return true;
    }

    protected int populatePopup() {
        int xLoc = 5;
        if (this.getFigureBar() != null) {
            IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
            EditPartHyperLinkHelper diagramHelper = new EditPartHyperLinkHelper(host);
            this.hyperLinkObjectList = (ArrayList)diagramHelper.getHyperlinksFromEditPart(this.hyperlinkHelperFactory);
            xLoc = this.addObjectList(xLoc, this.hyperLinkObjectList);
            PopupBarLabelPlusHandle handle = new PopupBarLabelPlusHandle();
            Rectangle r1 = new Rectangle();
            r1.setLocation(xLoc, 5);
            xLoc += 20;
            r1.setSize(16, 16);
            Label l = new Label();
            l.setText("Add Diagram");
            handle.setToolTip((IFigure)l);
            handle.setPreferredSize(16, 16);
            handle.setBounds(r1);
            handle.setBackgroundColor(ColorConstants.white);
            this.getFigureBar().add((IFigure)handle);
            handle.addMouseListener((MouseListener)this.myMouseKeyListener);
            handle.addMouseMotionListener((MouseMotionListener)this);
        }
        return xLoc;
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (this.getFigureBar() == null) {
            this.createPopupBarFigure();
            int width = this.populatePopup();
            IFigure layer = this.getLayer("Handle Layer");
            layer.add(this.getFigureBar());
            if (referencePoint == null) {
                referencePoint = this.getHostFigure().getBounds().getCenter();
            }
            Point position = this.getHostFigure().getBounds().getBottomLeft();
            this.getHostFigure().translateToAbsolute((Translatable)position);
            EditPartViewer viewer = this.getHost().getRoot().getViewer();
            Viewport viewport = null;
            if (viewer instanceof DiagramGraphicalViewer) {
                viewport = ((FigureCanvas)((DiagramGraphicalViewer)viewer).getControl()).getViewport();
            }
            if (viewport != null) {
                position.x += viewport.getClientArea().x;
                position.y += viewport.getClientArea().y;
            }
            this.getFigureBar().setSize(width, 30);
            this.getFigureBar().setLocation(position);
            this.getFigureBar().setBackgroundColor(ColorConstants.white);
            this.getFigureBar().setForegroundColor(ColorConstants.orange);
            if (!this.shouldAvoidHidingDiagramAssistant()) {
                this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
            }
        }
    }

    private class PopupBarLabelHandle
    extends Label
    implements Handle {
        private boolean myMouseOver;
        private Object myObject;

        public PopupBarLabelHandle(Object anObject, Image theImage) {
            super(theImage);
            this.myMouseOver = false;
            this.myObject = null;
            this.myObject = anObject;
            this.setOpaque(true);
            this.setBackgroundColor(ColorConstants.buttonLightest);
        }

        public void dispose() {
            if (this.getIcon() != null && !this.getIcon().isDisposed()) {
                this.getIcon().dispose();
            }
        }

        public Point getAccessibleLocation() {
            return null;
        }

        public DragTracker getDragTracker() {
            return null;
        }

        public Object getReferencedObject() {
            return this.myObject;
        }

        public void handleMouseEntered(MouseEvent event) {
            super.handleMouseEntered(event);
            this.setBackgroundColor(ColorConstants.button);
            this.myMouseOver = true;
        }

        public void handleMouseExited(MouseEvent event) {
            super.handleMouseExited(event);
            this.setBackgroundColor(ColorConstants.white);
            this.myMouseOver = false;
        }

        public void handleMousePressed(MouseEvent event) {
            int cfr_ignored_0 = event.button;
            super.handleMousePressed(event);
        }

        protected void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
            if (this.myMouseOver) {
                Rectangle area = this.getClientArea();
                graphics.setForegroundColor(ColorConstants.black);
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
            }
        }

        protected void paintFigure(Graphics graphics) {
            Image theImage;
            if (!this.isEnabled() && (theImage = this.getIcon()) != null) {
                graphics.translate(this.bounds.x, this.bounds.y);
                graphics.drawImage(theImage, this.getIconLocation());
                graphics.translate(-this.bounds.x, -this.bounds.y);
                return;
            }
            super.paintFigure(graphics);
        }
    }

    private class PopupBarLabelPlusHandle
    extends PopupBarLabelHandle {
        public PopupBarLabelPlusHandle() {
            super(null, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.diagram.common", (String)"/icons/obj16/Plus.gif").createImage());
        }
    }

    private class PopupBarMouseListener
    extends MouseListener.Stub {
        private PopupBarMouseListener() {
        }

        public void mousePressed(MouseEvent me) {
            if (3 == me.button) {
                HyperLinkPopupBarEditPolicy.this.hideDiagramAssistant();
            }
            if (1 == me.button) {
                if (me.getSource() instanceof PopupBarLabelPlusHandle) {
                    HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell = new AdvancedHLManager(HyperLinkPopupBarEditPolicy.this.getEditorRegistry(), ((GraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getEditingDomain(), (Element)((GraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getNotationView().getElement(), ((GraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getNotationView(), HyperLinkPopupBarEditPolicy.topPackage((Element)((GraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getNotationView().getElement()), HyperLinkPopupBarEditPolicy.this.hyperlinkHelperFactory);
                    HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell.setInput(HyperLinkPopupBarEditPolicy.this.hyperLinkObjectList);
                    HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell.open();
                } else if (me.getSource() instanceof PopupBarLabelHandle && ((PopupBarLabelHandle)((Object)me.getSource())).getReferencedObject() instanceof HyperlinkObject) {
                    HyperlinkObject hyperLinkObject = (HyperlinkObject)((PopupBarLabelHandle)((Object)me.getSource())).getReferencedObject();
                    hyperLinkObject.executeSelectPressed();
                }
                HyperLinkPopupBarEditPolicy.this.hideDiagramAssistant();
            }
            super.mousePressed(me);
        }

        public void mouseReleased(MouseEvent me) {
            super.mouseReleased(me);
        }
    }

    private class RoundedRectangleWithTail
    extends RoundedRectangle {
        private boolean bIsInit = false;
        private final int myCornerDimension = 3;
        private Image myTailImage = null;

        public RoundedRectangleWithTail() {
            this.setFill(true);
            this.setBackgroundColor(ColorConstants.yellow);
            this.setForegroundColor(ColorConstants.orange);
            this.setVisible(true);
            this.setEnabled(true);
            this.setOpaque(true);
        }

        private Image getTail() {
            if (!this.bIsInit && this.myTailImage == null) {
                this.myTailImage = IMAGE_POPUPBAR_PLUS;
                this.bIsInit = true;
            }
            return this.myTailImage;
        }
    }
}

