/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.dialogs.DiagramNavigationDialog;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.DiagramHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.DocumentHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.EditPartHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.helper.HyperlinkHelperFactory;
import org.eclipse.papyrus.diagram.common.helper.WebHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.AdvancedHLManager;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkManagerShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class NavigationEditPolicy
extends OpenEditPolicy {
    public static final String NAVIGATION_POLICY = "NavigationEditPolicy";
    private IPageIconsRegistry editorRegistry;

    public static Package topPackage(Element element) {
        if (element.getOwner() == null) {
            return (Package)element;
        }
        return NavigationEditPolicy.topPackage(element.getOwner());
    }

    protected Command getOpenCommand(Request request) {
        final IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost();
        final EObject semanticElement = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (semanticElement == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EditPartHyperLinkHelper diagramHelper = new EditPartHyperLinkHelper(gep);
        try {
            String navigationKind = org.eclipse.papyrus.preferences.Activator.getDefault().getPreferenceStore().getString("PAPYRUS_NAVIGATION_DOUBLECLICK_KIND");
            if (navigationKind.equals("NO_NAVIGATION")) {
                return UnexecutableCommand.INSTANCE;
            }
            if (navigationKind.equals("EXPLICIT_IMPLICIT_NAVIGATION")) {
                ArrayList<AbstractHyperLinkHelper> hyperLinkHelpers = new ArrayList<AbstractHyperLinkHelper>();
                hyperLinkHelpers.add(new DiagramHyperLinkHelper());
                hyperLinkHelpers.add(new DocumentHyperLinkHelper());
                hyperLinkHelpers.add(new WebHyperLinkHelper());
                final HyperlinkHelperFactory hyperlinkHelperFactory = new HyperlinkHelperFactory(hyperLinkHelpers);
                final ArrayList hyperLinkObjectList = (ArrayList)diagramHelper.getHyperlinksFromEditPart(hyperlinkHelperFactory);
                Predicate<HyperlinkObject> filterDefaultHyperlinks = new Predicate<HyperlinkObject>(){

                    public boolean apply(HyperlinkObject hyperLinkObject) {
                        return hyperLinkObject.getIsDefault();
                    }
                };
                Iterable defaultHyperLinksIterable = Iterables.filter((Iterable)hyperLinkObjectList, (Predicate)filterDefaultHyperlinks);
                int defaultHyperLinksCount = Iterables.size((Iterable)defaultHyperLinksIterable);
                final ArrayList defaultHyperLinkObject = Lists.newArrayList((Iterable)defaultHyperLinksIterable);
                if (defaultHyperLinksCount == 0) {
                    Command command = new Command(){

                        public void execute() {
                            AdvancedHLManager hyperLinkManagerShell = new AdvancedHLManager(NavigationEditPolicy.this.getEditorRegistry(), ((IGraphicalEditPart)NavigationEditPolicy.this.getHost()).getEditingDomain(), (Element)gep.getNotationView().getElement(), gep.getNotationView(), NavigationEditPolicy.topPackage((Element)semanticElement), hyperlinkHelperFactory);
                            ((HyperLinkManagerShell)hyperLinkManagerShell).setInput(hyperLinkObjectList);
                            hyperLinkManagerShell.open();
                        }
                    };
                    return command;
                }
                if (defaultHyperLinksCount == 1) {
                    Command command = new Command(){

                        public void execute() {
                            super.execute();
                            ((HyperlinkObject)defaultHyperLinkObject.get(0)).executeSelectPressed();
                        }
                    };
                    return command;
                }
                if (defaultHyperLinksCount > 1) {
                    DiagramNavigationDialog diagramNavigationDialog = new DiagramNavigationDialog(new Shell(), defaultHyperLinkObject);
                    diagramNavigationDialog.open();
                    final ArrayList<HyperlinkObject> hList = diagramNavigationDialog.getSelectedHyperlinks();
                    Command command = new Command(){

                        public void execute() {
                            super.execute();
                            for (HyperlinkObject hyperlinkObject : hList) {
                                hyperlinkObject.executeSelectPressed();
                            }
                        }
                    };
                    return command;
                }
            }
        }
        catch (Exception e) {
            Activator.log.error("Impossible to load hyperlinks", (Throwable)e);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }
}

