/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.diagram.common.editparts.IPapyrusEditPart;
import org.eclipse.papyrus.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.umlutils.ui.helper.QualifiedNameHelper;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class QualifiedNameDisplayEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String QUALIFIED_NAME_POLICY = "Qualified_name_editpolicy";
    protected NamedElement hostSemanticNamedElement;
    protected List<Object> parentListeners;

    public void activate() {
        View view = (View)this.getHost().getModel();
        if (view == null) {
            return;
        }
        this.hostSemanticNamedElement = this.getNamedElement();
        if (this.hostSemanticNamedElement != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
            if (this.hostSemanticNamedElement == null) {
                return;
            }
            this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticNamedElement, (NotificationListener)this);
            this.refreshQualifiedNameDisplay();
        }
        this.addParentListeners();
    }

    protected void refreshQualifiedNameDisplay() {
        if (this.getHost() instanceof IPapyrusEditPart && ((IPapyrusEditPart)this.getHost()).getPrimaryShape() instanceof NodeNamedElementFigure) {
            NodeNamedElementFigure nodeNamedElementFigure = (NodeNamedElementFigure)((IPapyrusEditPart)this.getHost()).getPrimaryShape();
            this.refreshQualifiedNameDepth(nodeNamedElementFigure);
            this.refreshQualifiedName(nodeNamedElementFigure);
        }
    }

    protected void refreshQualifiedName(NodeNamedElementFigure nodeNamedElementFigure) {
        nodeNamedElementFigure.setQualifiedName(this.hostSemanticNamedElement.getQualifiedName());
    }

    protected void refreshQualifiedNameDepth(NodeNamedElementFigure nodeNamedElementFigure) {
        nodeNamedElementFigure.setDepth(QualifiedNameHelper.getQualifiedNameDepth((EModelElement)((View)this.getHost().getModel())));
    }

    public void deactivate() {
        View view = (View)this.getHost().getModel();
        if (view == null) {
            return;
        }
        if (this.hostSemanticNamedElement != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticNamedElement, (NotificationListener)this);
        }
        this.hostSemanticNamedElement = null;
        this.removeParentListeners();
    }

    protected NamedElement getNamedElement() {
        View view = (View)this.getHost().getModel();
        if (view == null) {
            return null;
        }
        if (view.getElement() != null && view.getElement() instanceof NamedElement) {
            return (NamedElement)view.getElement();
        }
        return null;
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void notifyChanged(Notification notification) {
        EReference ref;
        if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(notification.getFeatureID(NamedElement.class)) || notification.getNotifier() instanceof EAnnotation) {
            this.refreshQualifiedNameDisplay();
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(notification.getFeature())) {
            if (this.parentListeners.contains(notification.getNotifier()) || this.getNamedElement().equals(notification.getNotifier())) {
                this.refreshQualifiedNameDisplay();
            }
        } else if (notification.getFeature() instanceof EReference && (ref = (EReference)notification.getFeature()).isContainment()) {
            if (this.parentListeners.contains(notification.getNotifier())) {
                this.removeParentListeners();
            }
            this.addParentListeners();
            this.refreshQualifiedNameDisplay();
        }
    }

    private void addParentListeners() {
        DiagramEventBroker diagramEventBroker = this.getDiagramEventBroker();
        if (diagramEventBroker != null) {
            if (this.parentListeners == null) {
                this.parentListeners = new ArrayList<Object>();
            }
            if (this.getNamedElement() != null) {
                EObject parentEOBject = this.getNamedElement().eContainer();
                while (parentEOBject != null) {
                    diagramEventBroker.addNotificationListener(parentEOBject, (NotificationListener)this);
                    this.parentListeners.add(parentEOBject);
                    parentEOBject = parentEOBject.eContainer();
                }
            }
        }
    }

    public void removeParentListeners() {
        for (Object listener : this.parentListeners) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)listener, (NotificationListener)this);
        }
    }
}

