/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.figure.edge;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.swt.graphics.Color;

public class DashedEdgeFigure
extends UMLEdgeFigure {
    private final int[] dashes = new int[10];
    protected boolean arrow = true;
    private WrappingLabel nameLabel;

    public DashedEdgeFigure() {
        this.setStyle();
    }

    public WrappingLabel getNameLabel() {
        return this.nameLabel;
    }

    public DashedEdgeFigure(Boolean arrow) {
        this.arrow = arrow;
        this.setStyle();
        this.createContents();
    }

    public void setArrow(Boolean arrow) {
        this.arrow = arrow;
        this.setStyle();
    }

    protected void createContents() {
        super.createContents();
        this.nameLabel = new WrappingLabel();
        this.nameLabel.setText("");
        this.add((IFigure)this.nameLabel);
    }

    protected void setStyle() {
        PolylineDecoration dec = new PolylineDecoration();
        dec.setScale(15.0, 5.0);
        dec.setLineWidth(1);
        if (this.arrow) {
            this.setTargetDecoration((RotatableDecoration)dec);
        } else {
            this.setTargetDecoration(null);
        }
        this.setLineStyle(6);
        int i = 0;
        while (i < 10) {
            this.dashes[i] = 5;
            ++i;
        }
        this.setLineDash(this.dashes);
    }

    protected void setStyle(int lineWidth) {
        this.setStyle();
        this.setLineWidth(lineWidth);
    }

    protected void setStyle(Color backgroundColor, Color foregroundColor, int lineWidth) {
        PolygonDecoration dec = new PolygonDecoration();
        dec.setScale(15.0, 5.0);
        dec.setBackgroundColor(backgroundColor);
        dec.setLineWidth(1);
        if (this.arrow) {
            this.setTargetDecoration((RotatableDecoration)dec);
        }
        this.setLineWidth(lineWidth);
        this.setLineStyle(6);
        this.setForegroundColor(foregroundColor);
        int i = 0;
        while (i < 10) {
            this.dashes[i] = 5;
            ++i;
        }
        this.setLineDash(this.dashes);
    }
}

