/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.figure.node;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ContainerBorder
extends AbstractBorder {
    private int lineWidth = 1;
    private Color color;
    protected Insets insets;

    public ContainerBorder(Color color, int lineWidth, Insets marginInsets) {
        this.setColor(color);
        this.setLineWidth(lineWidth);
        this.insets = marginInsets;
        this.insets.top += lineWidth;
    }

    public void setBorder(Color color) {
        this.setColor(color);
    }

    public ContainerBorder(Color color, int lineWidth, int allMargin) {
        this(color, lineWidth, new Insets(allMargin));
    }

    public ContainerBorder(Color color, int lineWidth, int t, int l, int b, int r) {
        this(color, lineWidth, new Insets(t, l, b, r));
    }

    public ContainerBorder(Color color) {
        this(color, 1, 1);
    }

    public ContainerBorder(int width) {
        this(null, width, width);
    }

    public ContainerBorder() {
    }

    public Color getColor() {
        return this.color;
    }

    public Insets getInsets(IFigure figure) {
        return this.insets;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.pushState();
        Rectangle bounds = figure.getBounds();
        graphics.setLineWidth(this.getLineWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawLine(bounds.getTopLeft(), bounds.getTopRight());
        graphics.popState();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }
}

