/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.figure.node;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.papyrus.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DiamondNode
extends PapyrusNodeFigure
implements IPapyrusNodeUMLElementFigure {
    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(20, 20);
    }

    protected Border getDefaultBorder(Color borderColor) {
        return null;
    }

    public void paintFigure(Graphics graphics) {
        graphics.pushState();
        Rectangle r = this.getBounds().getCopy().crop(new Insets(0, 0, 1, 1));
        PointList ptList = new PointList();
        ptList.addPoint(r.x + r.width / 2, r.y);
        ptList.addPoint(r.x + r.width, r.y + r.height / 2);
        ptList.addPoint(r.x + r.width / 2, r.y + r.height);
        ptList.addPoint(r.x, r.y + r.height / 2);
        if (this.isUsingGradient()) {
            graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        graphics.fillPolygon(ptList);
        graphics.setLineWidth(1);
        graphics.setBackgroundColor(this.getForegroundColor());
        graphics.drawPolygon(ptList);
        graphics.popState();
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
    }

    public Label getStereotypesLabel() {
        return new Label();
    }
}

