/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.figure.node;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.diagram.common.figure.node.CompartmentFigure;

public class ManualCompartmentLayoutManager
extends AbstractLayout {
    protected static final int MINIMUM_COMPARTMENT_HEIGHT = 15;
    protected ArrayList<IFigure> compartmentList = new ArrayList();
    protected ArrayList<IFigure> notCompartmentList = new ArrayList();

    protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
        int i;
        this.collectInformationOnChildren(container);
        int minimumWith = 0;
        int minimumHeight = 0;
        if (container instanceof CompartmentFigure && ((CompartmentFigure)container).getNameLabel() != null && ((CompartmentFigure)container).getNameLabel().getPreferredSize().width > minimumWith) {
            minimumWith = ((CompartmentFigure)container).getNameLabel().getPreferredSize().width;
        }
        if (this.compartmentList.size() != 0) {
            i = 0;
            while (i < container.getChildren().size()) {
                minimumHeight += ((IFigure)container.getChildren().get((int)i)).getPreferredSize().height;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.notCompartmentList.size()) {
                minimumHeight += this.notCompartmentList.get((int)i).getPreferredSize().height;
                ++i;
            }
        }
        return new Dimension(minimumWith, minimumHeight += 7);
    }

    protected void layoutCenterForLabel(IFigure container) {
        int labelheight = 0;
        int i = 0;
        while (i < this.notCompartmentList.size()) {
            labelheight += this.notCompartmentList.get((int)i).getPreferredSize().height;
            ++i;
        }
        i = 0;
        while (i < container.getChildren().size()) {
            Rectangle bound;
            if (this.notCompartmentList.contains(container.getChildren().get(i))) {
                bound = new Rectangle(((IFigure)container.getChildren().get(i)).getBounds());
                bound.setSize(this.getPreferedSize((IFigure)container.getChildren().get(i)));
                if (i > 0) {
                    bound.y = ((IFigure)container.getChildren().get((int)(i - 1))).getBounds().getBottomLeft().y + 1;
                    bound.x = container.getBounds().x + 3;
                    bound.width = container.getBounds().width;
                } else {
                    bound.x = container.getBounds().x + 3;
                    bound.y = container.getBounds().y + (container.getBounds().height - labelheight) / 2;
                    bound.width = container.getBounds().width;
                }
                ((IFigure)container.getChildren().get(i)).setBounds(bound);
            } else {
                bound = new Rectangle(((IFigure)container.getChildren().get(i)).getBounds());
                bound.y = container.getBounds().getBottomLeft().y + 1;
                bound.x = container.getBounds().x + 3;
                ((IFigure)container.getChildren().get(i)).setBounds(bound);
            }
            ++i;
        }
    }

    public void layout(IFigure container) {
        this.collectInformationOnChildren(container);
        int containersize = container.getChildren().size();
        if (this.compartmentList.size() != 0) {
            List childrenList = container.getChildren();
            int i = 0;
            while (i < container.getChildren().size()) {
                Rectangle bound = new Rectangle(((IFigure)childrenList.get(i)).getBounds());
                bound.setSize(this.getPreferedSize((IFigure)childrenList.get(i)));
                if (i > 0) {
                    bound.y = ((IFigure)childrenList.get((int)(i - 1))).getBounds().getBottomLeft().y + 1;
                    if (this.compartmentList.contains(childrenList.get(i))) {
                        bound.x = container.getBounds().x;
                    }
                    bound.width = container.getBounds().width;
                } else {
                    bound.x = container.getBounds().x + 3;
                    bound.y = container.getBounds().y;
                    bound.width = container.getBounds().width;
                }
                ((IFigure)childrenList.get(i)).setBounds(bound);
                ++i;
            }
            this.optimizeCompartmentSize(container);
            Rectangle lastRectangle = ((IFigure)container.getChildren().get(containersize - 1)).getBounds();
            lastRectangle.height = container.getBounds().y + container.getBounds().height - lastRectangle.y;
            lastRectangle.width = container.getBounds().width;
            ((IFigure)container.getChildren().get(containersize - 1)).setBounds(lastRectangle);
        } else {
            this.layoutCenterForLabel(container);
        }
    }

    protected void optimizeCompartmentSize(IFigure container) {
        int compartmentsHeight = 0;
        int notCompartmentsHeight = 0;
        int i = 0;
        while (i < this.notCompartmentList.size()) {
            notCompartmentsHeight += this.notCompartmentList.get((int)i).getBounds().height;
            ++i;
        }
        i = 0;
        while (i < this.compartmentList.size()) {
            compartmentsHeight += this.compartmentList.get((int)i).getBounds().height;
            ++i;
        }
        int remainingspace = container.getBounds().height - notCompartmentsHeight;
        double ratio = new Integer(compartmentsHeight).doubleValue() / new Integer(remainingspace).doubleValue();
        int i2 = 0;
        while (i2 < this.compartmentList.size()) {
            int value;
            Rectangle bound = new Rectangle(this.compartmentList.get(i2).getBounds());
            bound.height = value = (int)((double)bound.height / ratio);
            bound.x = container.getBounds().x;
            if (i2 > 0) {
                bound.y = this.compartmentList.get((int)(i2 - 1)).getBounds().getBottomLeft().y + 1;
            }
            ++i2;
        }
    }

    public void collectInformationOnChildren(IFigure container) {
        this.compartmentList = new ArrayList();
        this.notCompartmentList = new ArrayList();
        int i = 0;
        while (i < container.getChildren().size()) {
            if (this.isAGMFContainer((IFigure)container.getChildren().get(i))) {
                this.compartmentList.add((IFigure)container.getChildren().get(i));
            } else if (container.getChildren().get(i) instanceof Label || container.getChildren().get(i) instanceof WrappingLabel) {
                this.notCompartmentList.add((IFigure)container.getChildren().get(i));
            }
            ++i;
        }
    }

    public Dimension getPreferedSize(IFigure figure) {
        Dimension dim = figure.getPreferredSize();
        return dim;
    }

    public boolean isAGMFContainer(IFigure figure) {
        return figure.getChildren().size() > 0 && figure.getChildren().get(0) instanceof ResizableCompartmentFigure;
    }
}

