/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.figure.node;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.NoteFigure;
import org.eclipse.papyrus.diagram.common.figure.node.RectangularShadowBorder;
import org.eclipse.swt.graphics.Color;

public class NoteShadowBorder
extends RectangularShadowBorder {
    protected Dimension cornerDim;
    private NoteFigure.NoteFigureBorder noteBorder;

    public NoteShadowBorder(int borderwidth, Color color, Dimension cornerDim, NoteFigure.NoteFigureBorder noteBorder) {
        super(borderwidth, color);
        this.cornerDim = cornerDim;
        this.noteBorder = noteBorder;
    }

    public Insets getMargin() {
        return this.noteBorder.getMargin();
    }

    public Insets getInsets(IFigure figure) {
        return this.noteBorder.getInsets(figure);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.pushState();
        this.noteBorder.paint(figure, graphics, insets);
        Rectangle newRect = new Rectangle(figure.getBounds());
        Rectangle figureRect = new Rectangle(figure.getBounds());
        newRect.width += this.borderwidth;
        newRect.height += this.borderwidth;
        graphics.setClip(newRect);
        PointList plt = new PointList();
        plt.addPoint(figureRect.x + figureRect.width, figureRect.y + this.borderwidth + this.cornerDim.height);
        plt.addPoint(figureRect.x + figureRect.width, figureRect.y + figureRect.height);
        plt.addPoint(figureRect.x + this.borderwidth, figureRect.y + figureRect.height);
        plt.addPoint(figureRect.x + this.borderwidth, figureRect.y + figureRect.height + this.borderwidth);
        plt.addPoint(figureRect.x + figureRect.width + this.borderwidth, figureRect.y + figureRect.height + this.borderwidth);
        plt.addPoint(figureRect.x + figureRect.width + this.borderwidth, figureRect.y + this.borderwidth + this.cornerDim.height + this.borderwidth);
        plt.addPoint(figureRect.x + figureRect.width, figureRect.y + this.borderwidth + this.cornerDim.height);
        if (this.getColor() != null) {
            graphics.setBackgroundColor(this.getColor());
        } else {
            graphics.setBackgroundColor(ColorConstants.black);
        }
        graphics.fillPolygon(plt);
        graphics.popState();
    }
}

