/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.figure.node;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;

public class SubCompartmentLayoutManager
extends AbstractLayout {
    protected static final int MINIMUMCOMPARTMENTSIZE = 15;
    protected static final int MINIMUM_COMPARTMENT_WIDTH = 20;
    protected int preferedHeight = 15;

    protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
        Object compartment;
        Dimension dim = new Dimension(10, this.preferedHeight);
        if (!figure.getChildren().isEmpty() && (compartment = figure.getChildren().get(0)) instanceof ResizableCompartmentFigure) {
            Dimension compartmentPreferredSize = ((ResizableCompartmentFigure)compartment).getPreferredSize();
            dim.height = compartmentPreferredSize.height + 10;
            if (dim.height == 0) {
                dim.height = 20;
            }
            dim.width = compartmentPreferredSize.width;
        }
        return dim;
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return new Dimension(20, 15);
    }

    public void layout(IFigure container) {
        int i = 0;
        while (i < container.getChildren().size()) {
            IFigure child = (IFigure)container.getChildren().get(i);
            Rectangle bound = new Rectangle(child.getBounds());
            bound.setSize(this.getPreferedSize(child));
            bound.x = container.getBounds().x;
            bound.width = container.getBounds().width;
            bound.y = i > 0 ? ((IFigure)container.getChildren().get((int)(i - 1))).getBounds().getBottomLeft().y + 1 : container.getBounds().y;
            child.setBounds(bound);
            ++i;
        }
        int containersize = container.getChildren().size();
        if (containersize > 0) {
            IFigure lastChild = (IFigure)container.getChildren().get(containersize - 1);
            Rectangle lastRectangle = lastChild.getBounds();
            lastRectangle.height = container.getBounds().y + container.getBounds().height - lastRectangle.y;
            lastRectangle.width = container.getBounds().width;
            lastChild.setBounds(lastRectangle);
        }
    }

    public Dimension getPreferedSize(IFigure figure) {
        Dimension dim = new Dimension(10, this.preferedHeight);
        if (figure.getChildren().size() > 0 && figure.getChildren().get(0) instanceof ResizableCompartmentFigure) {
            dim.height = ((ResizableCompartmentFigure)figure.getChildren().get((int)0)).getPreferredSize().height + 10;
            if (dim.height == 0) {
                dim.height = 20;
            }
        }
        return dim;
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.preferedHeight = constraint instanceof Rectangle && ((Rectangle)constraint).height > 15 ? ((Rectangle)constraint).height : 15;
        this.invalidate(child);
    }
}

