/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.handlers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.papyrus.ui.toolbox.notification.Type;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteFromDiagramCommandHandler
extends GraphicalCommandHandler
implements IHandler {
    @Override
    protected Command getCommand() throws ExecutionException {
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!this.supportViews(editParts) || this.isCanonical(editParts)) {
            CompositeCommand cc = new CompositeCommand("Deletation impossible command");
            for (final IGraphicalEditPart c : editParts) {
                AbstractTransactionalCommand cmd = new AbstractTransactionalCommand((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)c.resolveSemanticElement()), "test", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        EObject element = c.resolveSemanticElement();
                        EObject owner = element.eContainer();
                        if (element != null && owner != null && owner instanceof NamedElement) {
                            String elementLabel = this.getNameForElement(element);
                            String ownerName = this.getNameForElement(owner);
                            StringBuilder label = new StringBuilder("The element ");
                            NotificationBuilder popup = new NotificationBuilder().setAsynchronous(true).setTemporary(true).setMessage(label.append(elementLabel).append(" can be deleted because it synchronized with the element ").append(ownerName).toString()).setType(Type.INFO);
                            popup.run();
                            return CommandResult.newCancelledCommandResult();
                        }
                        return CommandResult.newCancelledCommandResult();
                    }

                    protected String getNameForElement(EObject element) {
                        String elementLabel = element instanceof NamedElement ? ((NamedElement)element).getName() : "of type" + element.eClass().getName();
                        return elementLabel;
                    }
                };
                cc.compose((IUndoableOperation)cmd);
            }
            return new ICommandProxy((ICommand)cc);
        }
        CompoundCommand command = new CompoundCommand("Delete From Diagram");
        for (IGraphicalEditPart editPart : editParts) {
            command.add(editPart.getCommand((Request)new GroupRequest((Object)"delete")));
        }
        return command;
    }

    private boolean supportViews(List<IGraphicalEditPart> editParts) {
        for (IGraphicalEditPart object : editParts) {
            if (!(object instanceof GraphicalEditPart) || ((GraphicalEditPart)object).hasNotationView()) continue;
            return false;
        }
        return true;
    }

    protected boolean isCanonical(List<IGraphicalEditPart> editParts) {
        boolean isCanonical = false;
        if (!editParts.isEmpty()) {
            Iterator<IGraphicalEditPart> si = editParts.iterator();
            while (si.hasNext() && !isCanonical) {
                ConnectionEditPart connection;
                IGraphicalEditPart child = si.next();
                View view = (View)child.getAdapter(View.class);
                isCanonical = view == null || view.getElement() == null || view.getElement() instanceof View ? false : (child instanceof ConnectionEditPart ? !(connection = (ConnectionEditPart)child).isSemanticConnection() : this.isCanonical((EditPart)child));
            }
        }
        return isCanonical;
    }

    protected boolean isCanonical(EditPart ep) {
        EObject eObject = (EObject)ep.getAdapter(EObject.class);
        EditPart parent = ep.getParent();
        if (eObject != null && parent != null) {
            CanonicalEditPolicy cep = (CanonicalEditPolicy)parent.getEditPolicy((Object)"Canonical");
            return cep != null && cep.isEnabled() && cep.canCreate(eObject);
        }
        return false;
    }
}

