/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.commands.CreateHyperLinkDiagramCommand;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.EditorHyperlinkDiagramShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkDiagram;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramHyperLinkHelper
extends AbstractHyperLinkHelper {
    @Override
    public HyperlinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        if (eAnnotation.getSource().equals("PapyrusHyperLink_Diagram")) {
            HyperLinkDiagram hyperLinkDiagram = new HyperLinkDiagram();
            EList list = eAnnotation.getReferences();
            if (list.size() > 0 && ((EObject)eAnnotation.getReferences().get(0)).eResource() != null) {
                hyperLinkDiagram.setDiagram((Diagram)eAnnotation.getReferences().get(0));
                hyperLinkDiagram.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
                if (eAnnotation.getDetails().get((Object)"is_default_navigation") != null) {
                    String stringboolean = (String)eAnnotation.getDetails().get((Object)"is_default_navigation");
                    boolean isDefaultNaviagation = Boolean.parseBoolean(stringboolean);
                    hyperLinkDiagram.setIsDefault(isDefaultNaviagation);
                } else {
                    hyperLinkDiagram.setIsDefault(false);
                }
                return hyperLinkDiagram;
            }
        }
        return null;
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperlinkObject hyperlinkObject) {
        if (hyperlinkObject instanceof HyperLinkDiagram) {
            HyperLinkDiagram hyperLinkDiagram = (HyperLinkDiagram)hyperlinkObject;
            return new CreateHyperLinkDiagramCommand(domain, object, hyperLinkDiagram.getTooltipText(), hyperLinkDiagram.getDiagram().getName(), (EModelElement)hyperLinkDiagram.getDiagram(), hyperLinkDiagram.getIsDefault());
        }
        return null;
    }

    @Override
    public String getNameofManagedHyperLink() {
        return "Diagram";
    }

    @Override
    public void executeNewMousePressed(List<HyperlinkObject> list, Package amodel) {
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        EditorHyperlinkDiagramShell editor = new EditorHyperlinkDiagramShell(editorRegistry, amodel);
        editor.open();
        if (editor.getHyperLinkDiagram() != null) {
            list.add(editor.getHyperLinkDiagram());
        }
    }

    @Override
    public ArrayList<HyperlinkObject> getFilteredObject(List<HyperlinkObject> hyperlinkObjects) {
        ArrayList<HyperlinkObject> result = new ArrayList<HyperlinkObject>();
        for (HyperlinkObject hyperlinkObject : hyperlinkObjects) {
            if (!(hyperlinkObject instanceof HyperLinkDiagram)) continue;
            result.add(hyperlinkObject);
        }
        return result;
    }
}

