/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.diagram.common.commands.CreateHyperLinkDocumentCommand;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.EditorHyperlinkDocumentShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkDocument;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentHyperLinkHelper
extends AbstractHyperLinkHelper {
    @Override
    public HyperlinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        if (eAnnotation.getSource().equals("PapyrusHyperLink_Document")) {
            HyperlinkDocument hyperLinkDocument = new HyperlinkDocument();
            hyperLinkDocument.setHyperlinkDocument((String)eAnnotation.getDetails().get((Object)"localization"));
            hyperLinkDocument.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
            if (eAnnotation.getDetails().get((Object)"is_default_navigation") != null) {
                boolean isDefaultNaviagation = Boolean.parseBoolean((String)eAnnotation.getDetails().get((Object)"is_default_navigation"));
                hyperLinkDocument.setIsDefault(isDefaultNaviagation);
            } else {
                hyperLinkDocument.setIsDefault(false);
            }
            return hyperLinkDocument;
        }
        return null;
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperlinkObject hyperlinkObject) {
        if (hyperlinkObject instanceof HyperlinkDocument) {
            HyperlinkDocument hyperLinkDocument = (HyperlinkDocument)hyperlinkObject;
            return new CreateHyperLinkDocumentCommand(domain, object, hyperLinkDocument.getTooltipText(), hyperLinkDocument.getHyperlinkDocument(), hyperlinkObject.getIsDefault());
        }
        return null;
    }

    @Override
    public String getNameofManagedHyperLink() {
        return "Document";
    }

    @Override
    public void executeNewMousePressed(List<HyperlinkObject> list, Package amodel) {
        EditorHyperlinkDocumentShell editor = new EditorHyperlinkDocumentShell();
        editor.open();
        if (editor.getHyperlinkDocument() != null) {
            list.add(editor.getHyperlinkDocument());
        }
    }

    @Override
    public ArrayList<HyperlinkObject> getFilteredObject(List<HyperlinkObject> hyperlinkObjects) {
        ArrayList<HyperlinkObject> result = new ArrayList<HyperlinkObject>();
        for (HyperlinkObject hyperlinkObject : hyperlinkObjects) {
            if (!(hyperlinkObject instanceof HyperlinkDocument)) continue;
            result.add(hyperlinkObject);
        }
        return result;
    }
}

