/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.helper;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.helper.HyperlinkHelperFactory;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkDiagram;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.papyrus.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.navigation.NavigableElement;
import org.eclipse.papyrus.navigation.NavigationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPartHyperLinkHelper {
    private IGraphicalEditPart editPart;

    public EditPartHyperLinkHelper(IGraphicalEditPart editPart) {
        this.editPart = editPart;
    }

    private Iterable<Diagram> getAssociatedDiagramsIterable(ExistingNavigableElement navigableElement) {
        EObject element = navigableElement.getElement();
        final int finalMode = navigableElement.getNavigationMode();
        if (element == null || element.eResource() == null) {
            return Collections.emptyList();
        }
        Predicate<EStructuralFeature.Setting> filter = new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting setting) {
                boolean keep = false;
                if (finalMode == 0) {
                    keep = setting.getEObject() instanceof Diagram;
                } else if (finalMode == 1) {
                    keep = setting.getEObject() instanceof View;
                }
                return keep;
            }
        };
        Function<EStructuralFeature.Setting, Diagram> getDiagram = new Function<EStructuralFeature.Setting, Diagram>(){

            public Diagram apply(EStructuralFeature.Setting setting) {
                if (finalMode == 1) {
                    return ((View)setting.getEObject()).getDiagram();
                }
                return (Diagram)setting.getEObject();
            }
        };
        ECrossReferenceAdapter crossReferencer = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)element.eResource().getResourceSet());
        LinkedList settings = new LinkedList(crossReferencer.getInverseReferences(element));
        Iterable sortedSettings = Iterables.filter(settings, (Predicate)filter);
        Iterable diagrams = Iterables.transform((Iterable)sortedSettings, (Function)getDiagram);
        return diagrams;
    }

    public List<Diagram> getAssociatedDiagrams(ExistingNavigableElement navigableElement) {
        return Lists.newArrayList(this.getAssociatedDiagramsIterable(navigableElement));
    }

    public Iterable<HyperlinkObject> getAssociatedDiagramHyperlinksToAdd(Iterable<Diagram> diagrams, Iterable<HyperlinkObject> existingHyperlinks) {
        Function<Diagram, HyperlinkObject> getHyperlink = new Function<Diagram, HyperlinkObject>(){

            public HyperlinkObject apply(Diagram diagram) {
                HyperLinkDiagram hyperLinkDiagram = new HyperLinkDiagram();
                hyperLinkDiagram.setDiagram(diagram);
                hyperLinkDiagram.setTooltipText(String.valueOf(diagram.getName()) + " (found by heuristic)");
                return hyperLinkDiagram;
            }
        };
        final Iterable<HyperlinkObject> finalExistingHyperlinks = existingHyperlinks;
        Predicate<Diagram> discardAlreadyPointedDiagrams = new Predicate<Diagram>(){

            public boolean apply(Diagram diagram) {
                final Diagram finalDiagram = diagram;
                Predicate<HyperlinkObject> pointsAtDiagram = new Predicate<HyperlinkObject>(){

                    public boolean apply(HyperlinkObject hyperlinkObject) {
                        return hyperlinkObject.getObject().equals(finalDiagram);
                    }
                };
                return !Iterables.any((Iterable)finalExistingHyperlinks, (Predicate)pointsAtDiagram);
            }
        };
        final Iterable<Diagram> finalDiagrams = diagrams;
        Predicate<HyperlinkObject> discardIrrelevantHyperlinks = new Predicate<HyperlinkObject>(){

            public boolean apply(HyperlinkObject hyperlinkObject) {
                return Iterables.contains((Iterable)finalDiagrams, (Object)hyperlinkObject.getObject());
            }
        };
        Iterable newlyPointedDiagrams = Iterables.filter(diagrams, (Predicate)discardAlreadyPointedDiagrams);
        Iterable relevantExistingHyperlinks = Iterables.filter(existingHyperlinks, (Predicate)discardIrrelevantHyperlinks);
        Iterable newHyperLinkDiagrams = Iterables.transform((Iterable)newlyPointedDiagrams, (Function)getHyperlink);
        Iterable hyperLinkDiagramsToAdd = Iterables.concat((Iterable)newHyperLinkDiagrams, (Iterable)relevantExistingHyperlinks);
        return hyperLinkDiagramsToAdd;
    }

    public List<HyperlinkObject> getHyperlinksFromEditPart(HyperlinkHelperFactory hyperlinkHelperFactory) {
        ArrayList<Object> existingHyperLinks = new ArrayList();
        ArrayList result = null;
        try {
            existingHyperLinks = hyperlinkHelperFactory.getAllreferenced((EModelElement)this.editPart.getNotationView());
            Predicate<HyperlinkObject> keepHyperLinkDiagrams = new Predicate<HyperlinkObject>(){

                public boolean apply(HyperlinkObject hyperlinkObject) {
                    return hyperlinkObject instanceof HyperLinkDiagram;
                }
            };
            Predicate discardHyperLinkDiagrams = Predicates.not((Predicate)keepHyperLinkDiagrams);
            Iterable existingHyperLinkDiagrams = Iterables.filter(existingHyperLinks, (Predicate)keepHyperLinkDiagrams);
            Iterable existingOtherHyperLinks = Iterables.filter(existingHyperLinks, (Predicate)discardHyperLinkDiagrams);
            EObject semanticElement = this.editPart.resolveSemanticElement();
            if (semanticElement != null) {
                List navElements = NavigationHelper.getInstance().getAllNavigableElements(semanticElement);
                ArrayList<Diagram> currentDiagramsToAdd = new ArrayList<Diagram>();
                for (NavigableElement navElement : navElements) {
                    if (!(navElement instanceof ExistingNavigableElement)) continue;
                    List<Diagram> diagramsToAdd = this.getAssociatedDiagrams((ExistingNavigableElement)navElement);
                    for (Diagram diagram : diagramsToAdd) {
                        if (Iterables.contains(currentDiagramsToAdd, (Object)diagram)) continue;
                        currentDiagramsToAdd.add(diagram);
                    }
                }
                Iterable<HyperlinkObject> hyperLinksToAdd = this.getAssociatedDiagramHyperlinksToAdd(currentDiagramsToAdd, existingHyperLinkDiagrams);
                final Diagram currentDiagram = this.editPart.getNotationView().getDiagram();
                Predicate<HyperlinkObject> discardCurrentDiagram = new Predicate<HyperlinkObject>(){

                    public boolean apply(HyperlinkObject hyperlinkObject) {
                        return !hyperlinkObject.getObject().equals(currentDiagram);
                    }
                };
                Iterable finalHyperLinksToAdd = Iterables.filter(hyperLinksToAdd, (Predicate)discardCurrentDiagram);
                result = Lists.newArrayList((Iterable)Iterables.concat((Iterable)existingOtherHyperLinks, (Iterable)finalHyperLinksToAdd));
            }
        }
        catch (Exception e) {
            Activator.log.error("Impossible to load hyperlinks", (Throwable)e);
        }
        return result;
    }
}

