/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.diagram.common.commands.DeleteHyperLinkDocumentCommand;
import org.eclipse.papyrus.diagram.common.commands.EmptyAllHyperLinkCommand;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkException;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkHelperFactory {
    protected ArrayList<AbstractHyperLinkHelper> hyperLinkHelpers = new ArrayList();

    public ArrayList<AbstractHyperLinkHelper> getHyperLinkHelpers() {
        return this.hyperLinkHelpers;
    }

    public HyperlinkHelperFactory(ArrayList<AbstractHyperLinkHelper> hyperLinkHelpers) {
        this.hyperLinkHelpers.clear();
        this.hyperLinkHelpers.addAll(hyperLinkHelpers);
    }

    public Command getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, List<HyperlinkObject> hyperlinkObjects) throws HyperLinkException {
        CompoundCommand cmpCommand = new CompoundCommand();
        for (HyperlinkObject hyperlinkObject : hyperlinkObjects) {
            RecordingCommand cmd = null;
            int i = 0;
            while (cmd == null && i < this.hyperLinkHelpers.size()) {
                cmd = this.hyperLinkHelpers.get(i).getAddHyperLinkCommand(domain, object, hyperlinkObject);
                ++i;
            }
            if (cmd == null) {
                throw new HyperLinkException("Impossible to find a command to serialize " + hyperlinkObject);
            }
            cmpCommand.append(cmd);
        }
        return cmpCommand;
    }

    public static RecordingCommand getRemoveHyperlinkCommand(TransactionalEditingDomain domain, EModelElement object, String localization) {
        return new DeleteHyperLinkDocumentCommand(domain, object, localization);
    }

    public ArrayList<?> getAllreferenced(EModelElement object) throws HyperLinkException {
        ArrayList<HyperlinkObject> result = new ArrayList<HyperlinkObject>();
        for (EAnnotation currentAnnotation : object.getEAnnotations()) {
            int i = 0;
            HyperlinkObject hyperlinkObject = null;
            while (hyperlinkObject == null && i < this.hyperLinkHelpers.size()) {
                hyperlinkObject = this.hyperLinkHelpers.get(i).getHyperLinkObject(currentAnnotation);
                ++i;
            }
            if (hyperlinkObject == null) continue;
            result.add(hyperlinkObject);
        }
        return result;
    }

    public static EmptyAllHyperLinkCommand getEmptyAllHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object) {
        return new EmptyAllHyperLinkCommand(domain, object);
    }
}

