/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.helper;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityConstrainedFlowLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityDirectionType;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.papyrus.diagram.common.figure.node.CenteredWrappedLabel;
import org.eclipse.swt.graphics.Image;

public abstract class StereotypeFigureHelper {
    private CenteredWrappedLabel fActionStereotypeLabel;
    private CenteredWrappedLabel stereotypePropertiesInBraceContent;
    private WrappingLabel stereotypePropertiesContent;
    private RectangleFigure stereotypeRectangle;
    private boolean stereotypePrinted;
    private IFigure container;
    private int topInset = 2;
    private int leftInset = 5;
    private int bottomInset = 5;
    private int rightInset = 5;
    private boolean isStereotypeContainerFilled = false;

    public StereotypeFigureHelper(IFigure containingFigure) {
        this.container = containingFigure;
        this.init();
        this.createContents();
    }

    protected void init() {
    }

    private void createContents() {
        this.stereotypeRectangle = new RectangleFigure();
        this.stereotypeRectangle.setFill(this.isStereotypeContainerFilled);
        this.stereotypeRectangle.setOutline(false);
        this.stereotypeRectangle.setLineWidth(1);
        this.stereotypePrinted = false;
        GravityConstrainedFlowLayout layoutStereotypeRect0 = new GravityConstrainedFlowLayout();
        layoutStereotypeRect0.setGravity(GravityDirectionType.NORTH);
        layoutStereotypeRect0.setIgnoreInvisibleChildren(true);
        layoutStereotypeRect0.setStretchMajorAxis(false);
        layoutStereotypeRect0.setStretchMinorAxis(false);
        this.stereotypeRectangle.setLayoutManager((LayoutManager)layoutStereotypeRect0);
    }

    protected void ensureStereotypeRectanglePrinted() {
        if (!this.stereotypePrinted) {
            Object constraintStereotypeRect0 = this.getStereotypeRectangleConstraint();
            this.container.add((IFigure)this.stereotypeRectangle, constraintStereotypeRect0, 0);
            this.stereotypePrinted = true;
        }
    }

    protected void cleanStereotypeRectangle() {
        if (this.stereotypePrinted && this.stereotypeRectangle.getChildren().isEmpty()) {
            this.container.remove((IFigure)this.stereotypeRectangle);
            this.stereotypePrinted = false;
        }
    }

    protected void removeStereotypeLabel() {
        if (this.fActionStereotypeLabel != null) {
            this.stereotypeRectangle.remove((IFigure)this.fActionStereotypeLabel);
            this.fActionStereotypeLabel = null;
        }
        this.cleanStereotypeRectangle();
    }

    protected void createStereotypeLabel() {
        this.ensureStereotypeRectanglePrinted();
        this.fActionStereotypeLabel = new CenteredWrappedLabel();
        this.fActionStereotypeLabel.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(this.topInset), this.getMapMode().DPtoLP(this.leftInset), this.getMapMode().DPtoLP(this.bottomInset), this.getMapMode().DPtoLP(this.rightInset)));
        this.stereotypeRectangle.add((IFigure)this.fActionStereotypeLabel, (Object)0, 0);
    }

    protected void removeStereotypePropertiesInBraceLabel() {
        if (this.stereotypePropertiesInBraceContent != null) {
            this.stereotypeRectangle.remove((IFigure)this.stereotypePropertiesInBraceContent);
            this.stereotypePropertiesInBraceContent = null;
        }
        this.cleanStereotypeRectangle();
    }

    protected void createStereotypePropertiesInBraceLabel() {
        this.ensureStereotypeRectanglePrinted();
        this.stereotypePropertiesInBraceContent = new CenteredWrappedLabel();
        this.stereotypePropertiesInBraceContent.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(2), this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5)));
        this.stereotypeRectangle.add((IFigure)this.stereotypePropertiesInBraceContent, (Object)0, -1);
    }

    protected void removeStereotypePropertiesInCompartment() {
        if (this.stereotypePropertiesContent != null) {
            this.stereotypeRectangle.remove((IFigure)this.stereotypePropertiesContent);
            this.stereotypePropertiesContent = null;
        }
        this.cleanStereotypeRectangle();
    }

    protected void createStereotypePropertiesInCompartment() {
        this.ensureStereotypeRectanglePrinted();
        this.stereotypePropertiesContent = new WrappingLabel();
        this.stereotypePropertiesContent.setTextJustification(16384);
        this.stereotypePropertiesContent.setTextAlignment(1);
        this.stereotypePropertiesContent.setTextWrap(true);
        this.stereotypePropertiesContent.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(2), this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5)));
        this.stereotypeRectangle.add((IFigure)this.stereotypePropertiesContent, (Object)1, -1);
    }

    private void fillStereotypePropertiesInCompartment(String stereotypeProperties) {
        String propertiesString = stereotypeProperties;
        propertiesString = propertiesString.replace(";", "\n");
        propertiesString = propertiesString.replace("#", "\n  ");
        propertiesString = propertiesString.replace("|", "\n  ");
        this.stereotypePropertiesContent.setText(propertiesString);
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
        if (("".equals(stereotypes) || stereotypes == null) && image == null) {
            this.removeStereotypeLabel();
        } else {
            if (this.fActionStereotypeLabel == null) {
                this.createStereotypeLabel();
            }
            this.fActionStereotypeLabel.setText(stereotypes);
            this.fActionStereotypeLabel.setIcon(image);
        }
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
        if ("".equals(stereotypeProperties) || stereotypeProperties == null) {
            this.removeStereotypePropertiesInBraceLabel();
        } else {
            if (this.stereotypePropertiesInBraceContent == null) {
                this.createStereotypePropertiesInBraceLabel();
            }
            this.stereotypePropertiesInBraceContent.setText("{" + stereotypeProperties + "}");
        }
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        if ("".equals(stereotypeProperties) || stereotypeProperties == null) {
            this.removeStereotypePropertiesInCompartment();
        } else {
            if (this.stereotypePropertiesContent == null) {
                this.createStereotypePropertiesInCompartment();
            }
            this.fillStereotypePropertiesInCompartment(stereotypeProperties);
        }
    }

    public CenteredWrappedLabel getActionStereotypeLabel() {
        return this.fActionStereotypeLabel;
    }

    public abstract Object getStereotypeRectangleConstraint();

    public abstract IMapMode getMapMode();

    public int getTopInset() {
        return this.topInset;
    }

    public void setTopInset(int topInset) {
        this.topInset = topInset;
    }

    public int getLeftInset() {
        return this.leftInset;
    }

    public void setLeftInset(int leftInset) {
        this.leftInset = leftInset;
    }

    public int getBottomInset() {
        return this.bottomInset;
    }

    public void setBottomInset(int bottomInset) {
        this.bottomInset = bottomInset;
    }

    public int getRightInset() {
        return this.rightInset;
    }

    public void setRightInset(int rightInset) {
        this.rightInset = rightInset;
    }

    public boolean isStereotypeContainerFilled() {
        return this.isStereotypeContainerFilled;
    }

    public void setStereotypeContainerFilled(boolean isStereotypeContainerFilled) {
        this.isStereotypeContainerFilled = isStereotypeContainerFilled;
    }
}

