/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.diagram.common.commands.CreateHyperLinkWebCommand;
import org.eclipse.papyrus.diagram.common.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.EditorHyperlinkWebShell;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperLinkWeb;
import org.eclipse.papyrus.diagram.common.ui.hyperlinkshell.HyperlinkObject;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebHyperLinkHelper
extends AbstractHyperLinkHelper {
    @Override
    public HyperlinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        if (eAnnotation.getSource().equals("PapyrusHyperLink_web")) {
            HyperLinkWeb hyperLinkWeb = new HyperLinkWeb();
            hyperLinkWeb.setHyperLinkWeb((String)eAnnotation.getDetails().get((Object)"link"));
            hyperLinkWeb.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
            if (eAnnotation.getDetails().get((Object)"is_default_navigation") != null) {
                boolean isDefaultNaviagation = Boolean.parseBoolean((String)eAnnotation.getDetails().get((Object)"is_default_navigation"));
                hyperLinkWeb.setIsDefault(isDefaultNaviagation);
            } else {
                hyperLinkWeb.setIsDefault(false);
            }
            return hyperLinkWeb;
        }
        return null;
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperlinkObject hyperlinkObject) {
        if (hyperlinkObject instanceof HyperLinkWeb) {
            HyperLinkWeb hyperLinkWeb = (HyperLinkWeb)hyperlinkObject;
            return new CreateHyperLinkWebCommand(domain, object, hyperLinkWeb.getTooltipText(), hyperLinkWeb.getHyperLinkWeb(), hyperlinkObject.getIsDefault());
        }
        return null;
    }

    @Override
    public String getNameofManagedHyperLink() {
        return "Web";
    }

    @Override
    public void executeNewMousePressed(List<HyperlinkObject> list, Package amodel) {
        EditorHyperlinkWebShell editor = new EditorHyperlinkWebShell();
        editor.open();
        if (editor.getHyperLinkWeb() != null) {
            list.add(editor.getHyperLinkWeb());
        }
    }

    @Override
    public ArrayList<HyperlinkObject> getFilteredObject(List<HyperlinkObject> hyperlinkObjects) {
        ArrayList<HyperlinkObject> result = new ArrayList<HyperlinkObject>();
        for (HyperlinkObject hyperlinkObject : hyperlinkObjects) {
            if (!(hyperlinkObject instanceof HyperLinkWeb)) continue;
            result.add(hyperlinkObject);
        }
        return result;
    }
}

