/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.layout;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.papyrus.diagram.common.layout.LayoutUtils;

public class EditPartRepresentation {
    private final EditPart representedEditPart;
    private Request request = null;
    private Dimension delta = new Dimension(0, 0);

    public EditPartRepresentation(EditPart ep) {
        this.representedEditPart = ep;
    }

    public EditPart getRepresentedEditPart() {
        return this.representedEditPart;
    }

    public PrecisionRectangle getPosition() {
        return LayoutUtils.getAbsolutePosition(this.representedEditPart);
    }

    public Command getCommand() {
        if (this.request != null) {
            return this.representedEditPart.getCommand(this.request);
        }
        return null;
    }

    public void setRequest(ChangeBoundsRequest req) {
        this.request = req;
    }

    public void setMoveDelta(Dimension delta) {
        this.delta = delta;
    }

    public Dimension getMoveDelta() {
        return this.delta;
    }
}

