/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.layout;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditPartTree
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1557787740787257844L;
    private boolean isFirstSelected = false;
    private boolean isReference = false;
    private boolean isSelected = false;
    private Request request;

    public EditPartTree(Object editpart, boolean isSelected) {
        super(editpart, true);
        this.isSelected = isSelected;
    }

    public EditPartTree(List<EditPart> editparts) {
        this(null, false);
        this.buildTree(editparts);
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setIsReference(boolean isReference) {
        this.isReference = true;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public EditPart getEditPart() {
        return (EditPart)this.getUserObject();
    }

    @Override
    public String toString() {
        this.getLevel();
        String str = "";
        int i = 0;
        while (i < this.getLevel()) {
            str = String.valueOf(str) + "  ";
            ++i;
        }
        str = String.valueOf(str) + "isSelected =" + this.isSelected() + " depth =" + this.getDepth() + " Node =" + this.userObject + "\n";
        if (this.children != null) {
            i = 0;
            while (i < this.children.size()) {
                str = String.valueOf(str) + this.children.get(i).toString();
                ++i;
            }
        } else {
            i = 0;
            while (i < this.getLevel() + 2) {
                str = String.valueOf(str) + "  ";
                ++i;
            }
            str = String.valueOf(str) + "No child\n";
        }
        return str;
    }

    public EditPartTree getTree(EditPart editpart) {
        if (this.getEditPart() == editpart) {
            return this;
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                EditPart ep = ((EditPartTree)this.children.get(i)).getEditPart();
                if (ep == editpart) {
                    return (EditPartTree)this.children.get(i);
                }
                EditPartTree ept = ((EditPartTree)this.children.get(i)).getTree(editpart);
                if (ept != null) {
                    return ept;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean contains(EditPart editpart) {
        return this.getTree(editpart) != null;
    }

    public List<EditPartTree> getChildLevel(int level) {
        ArrayList<EditPartTree> epList = new ArrayList<EditPartTree>();
        if (level > 0) {
            if (level == 1 && this.children != null && this.children.size() != 0) {
                epList.addAll(this.children);
            } else if (this.children != null) {
                int iter = 0;
                while (iter < this.children.size()) {
                    epList.addAll(((EditPartTree)this.children.get(iter)).getChildLevel(level - 1));
                    ++iter;
                }
            }
        }
        return epList;
    }

    public void setFirstSelectedElement(boolean value) {
        this.isFirstSelected = value;
    }

    public boolean isFirstSelected() {
        return this.isFirstSelected;
    }

    public int getLevelForFirstSelectedElement() {
        EditPartTree result;
        TreeNode[] path = this.getPath();
        if (path.length > 1 && (result = this.getSelectedFirstEditPart((EditPartTree)path[1])) != null) {
            return result.getLevel();
        }
        return -1;
    }

    protected EditPartTree getSelectedFirstEditPart(EditPartTree treeNode) {
        if (treeNode.isFirstSelected) {
            return treeNode;
        }
        if (treeNode.children != null && !treeNode.children.isEmpty()) {
            int iter = 0;
            while (iter < treeNode.getChildCount()) {
                EditPartTree result = this.getSelectedFirstEditPart((EditPartTree)treeNode.children.get(iter));
                if (result != null) {
                    return result;
                }
                ++iter;
            }
        }
        return null;
    }

    public boolean existsUnselectedChild() {
        return this.getDistanceWithTheFirstUnselectedChild() != -1;
    }

    public int getDistanceWithTheFirstUnselectedChild() {
        int depth = this.getDepth();
        int i = 0;
        while (i < depth) {
            List<EditPartTree> localChildren = this.getChildLevel(i);
            for (EditPartTree tree : localChildren) {
                if (tree.isSelected()) continue;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public EditPartTree getFirstUnselectedChild() {
        int depth = this.getDepth();
        int i = 0;
        while (i < depth) {
            List<EditPartTree> localChildren = this.getChildLevel(i);
            for (EditPartTree tree : localChildren) {
                if (tree.isSelected()) continue;
                return tree;
            }
            ++i;
        }
        return null;
    }

    public void buildTree(List<EditPart> editparts) {
        if (editparts.size() >= 2) {
            for (EditPart currentEP : editparts) {
                ArrayList<EditPart> parentsList = new ArrayList<EditPart>();
                EditPart parent = currentEP;
                EditPartTree grandFatherTree = this;
                int i = 0;
                while (parent != null) {
                    if (this.contains(parent)) {
                        grandFatherTree = this.getTree(parent);
                        break;
                    }
                    if ((!(parent instanceof CompartmentEditPart) || parent instanceof CompartmentEditPart && parent == currentEP) && !(parent instanceof RootEditPart) && !(parent.getParent() instanceof RootEditPart)) {
                        parentsList.add(i, parent);
                        ++i;
                    }
                    parent = parent.getParent();
                }
                EditPartTree childTree = this.createChildrenTree(editparts, parentsList);
                if (childTree == null) continue;
                grandFatherTree.add(childTree);
            }
            this.getTree(editparts.get(editparts.size() - 1)).setIsReference(true);
            Enumeration<TreeNode> childrenEnum = this.children();
            block2: while (childrenEnum.hasMoreElements()) {
                EditPartTree currentTree = (EditPartTree)childrenEnum.nextElement();
                int i = 0;
                while (i < editparts.size()) {
                    if (currentTree.contains(editparts.get(i))) {
                        currentTree.getTree(editparts.get(i)).setFirstSelectedElement(true);
                        continue block2;
                    }
                    ++i;
                }
            }
            this.postBuildOperations(editparts);
        }
    }

    protected abstract EditPartTree createChildrenTree(List<EditPart> var1, List<EditPart> var2);

    protected abstract void postBuildOperations(List<EditPart> var1);
}

