/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.locator;

import org.eclipse.draw2d.geometry.Rectangle;

public class PortPositionLocatorUtils {
    public static Rectangle getBorderLocation(Rectangle parentFigureBounds, Rectangle proposedFigureBounds, int borderItemOffset) {
        Rectangle realLocation = proposedFigureBounds.getCopy();
        Rectangle parentRec = parentFigureBounds.getCopy();
        int xMin = -borderItemOffset;
        int xMax = -borderItemOffset + parentRec.width;
        int yMin = -borderItemOffset;
        int yMax = -borderItemOffset + parentRec.height;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        if (realLocation.y != yMin && realLocation.y != yMax && realLocation.x != xMin && realLocation.x != xMax) {
            realLocation.x = realLocation.x <= xMin + parentRec.width / 2 ? xMin : xMax;
        }
        return realLocation;
    }

    public static int getCurrentSideOfParent(Rectangle parentFigureBounds, Rectangle figureBounds, int borderItemOffset) {
        int position = 0;
        if (figureBounds.x != parentFigureBounds.width - borderItemOffset && figureBounds.x != -borderItemOffset && figureBounds.y == -borderItemOffset) {
            position = 1;
        } else if (figureBounds.x != parentFigureBounds.width - borderItemOffset && figureBounds.x != -borderItemOffset && figureBounds.y == parentFigureBounds.height - borderItemOffset) {
            position = 4;
        } else if (figureBounds.x == parentFigureBounds.width - borderItemOffset && figureBounds.y != -borderItemOffset && figureBounds.y != parentFigureBounds.height - borderItemOffset) {
            position = 16;
        } else if (figureBounds.x == -borderItemOffset && figureBounds.y != -borderItemOffset && figureBounds.y != parentFigureBounds.height - borderItemOffset) {
            position = 8;
        } else if (figureBounds.x == parentFigureBounds.width - borderItemOffset && figureBounds.y == -borderItemOffset) {
            position = 17;
        } else if (figureBounds.x == -borderItemOffset && figureBounds.y == -borderItemOffset) {
            position = 9;
        } else if (figureBounds.x == parentFigureBounds.width - borderItemOffset && figureBounds.y == parentFigureBounds.height - borderItemOffset) {
            position = 20;
        } else if (figureBounds.x == -borderItemOffset && figureBounds.y == parentFigureBounds.height - borderItemOffset) {
            position = 12;
        }
        return position;
    }
}

