/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.parser.lookup;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.parser.lookup.LookupResolveRequest;
import org.eclipse.papyrus.diagram.common.parser.lookup.LookupResolver;
import org.eclipse.uml2.uml.NamedElement;

public class LookupResolverImpl
implements LookupResolver {
    private LookupResolveRequest myTheOnlyRequest;
    private LookupResolver.Callback myTheOnlyCallback;
    private boolean myIsMultipleResolveRequired;
    private final IGraphicalEditPart myResolvingEditPart;

    public LookupResolverImpl(IGraphicalEditPart resolvingEditPart) {
        this.myResolvingEditPart = resolvingEditPart;
    }

    public void addLookupResolveRequest(LookupResolveRequest request, LookupResolver.Callback callback) {
        if (this.isEmpty()) {
            this.myTheOnlyCallback = callback;
            this.myTheOnlyRequest = request;
        } else {
            this.myIsMultipleResolveRequired = true;
        }
    }

    public boolean isEmpty() {
        return this.myTheOnlyCallback == null && this.myTheOnlyRequest == null;
    }

    public boolean canResolve() {
        return !this.isEmpty() && !this.myIsMultipleResolveRequired;
    }

    public AbstractTransactionalCommand getResolveCommand() {
        if (!this.canResolve()) {
            return null;
        }
        TransactionalEditingDomain domain = this.myResolvingEditPart.getEditingDomain();
        final CreateUnspecifiedTypeRequest createRequest = new CreateUnspecifiedTypeRequest(this.myTheOnlyRequest.getElementTypes(), this.myResolvingEditPart.getDiagramPreferencesHint());
        final Command gefCommand = this.myResolvingEditPart.getCommand((Request)createRequest);
        if (!gefCommand.canExecute()) {
            return null;
        }
        return new AbstractTransactionalCommand(domain, "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                gefCommand.execute();
                NamedElement resolution = this.getNewObject();
                if (resolution != null) {
                    resolution.eSet(LookupResolverImpl.this.myTheOnlyRequest.getInitFeature(), LookupResolverImpl.this.myTheOnlyRequest.getInitValue());
                    LookupResolverImpl.this.myTheOnlyCallback.lookupResolved(resolution);
                }
                return CommandResult.newOKCommandResult();
            }

            private NamedElement getNewObject() {
                for (Object next : createRequest.getElementTypes()) {
                    IElementType nextElementType = (IElementType)next;
                    CreateRequest nextRequest = createRequest.getRequestForType(nextElementType);
                    List allNew = (List)nextRequest.getNewObject();
                    for (Object nextCreated : allNew) {
                        EObject createdEntity;
                        View createdView;
                        if (!(nextCreated instanceof IAdaptable) || (createdView = (View)((IAdaptable)nextCreated).getAdapter(View.class)) == null || !((createdEntity = createdView.getElement()) instanceof NamedElement)) continue;
                        return (NamedElement)createdEntity;
                    }
                }
                return null;
            }
        };
    }
}

