/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.part;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.diagram.common.util.MDTUtil;
import org.eclipse.papyrus.diagram.common.util.PathsUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class CachedResourcesEditorInput
extends URIEditorInput {
    private boolean unload = true;
    private boolean openInNewEditor = false;

    public CachedResourcesEditorInput(URI uri) {
        super(uri);
    }

    public CachedResourcesEditorInput(URI uri, String name) {
        super(uri, name);
    }

    public CachedResourcesEditorInput(URI uri, String name, boolean unload) {
        this(uri, name, unload, false);
    }

    public CachedResourcesEditorInput(URI uri, boolean unload) {
        this(uri, null, unload, false);
    }

    public CachedResourcesEditorInput(URI uri, String name, boolean unload, boolean openInNewEditor) {
        super(uri, name);
        this.unload = unload;
        this.openInNewEditor = openInNewEditor;
    }

    public void setUnload(boolean unload) {
        this.unload = unload;
    }

    public boolean isUnload() {
        return this.unload;
    }

    public void setOpenInNewEditor(boolean openInNewEditor) {
        this.openInNewEditor = openInNewEditor;
    }

    public boolean isOpenInNewEditor() {
        return this.openInNewEditor;
    }

    public static boolean checkSameEditorInput(IEditorInput input1, IEditorInput input2) {
        String uri1 = "";
        String uri2 = "";
        uri1 = PathsUtil.getRelativeWorkspaceFromEditorInput(input1);
        return uri1.equals(uri2 = PathsUtil.getRelativeWorkspaceFromEditorInput(input2));
    }

    public static boolean checkSameEditorInputWithFragment(IEditorInput input1, IEditorInput input2) {
        String uri1 = "";
        String uri2 = "";
        uri1 = PathsUtil.getRelativeWorkspaceFromEditorInputWithFragment(input1);
        return uri1.equals(uri2 = PathsUtil.getRelativeWorkspaceFromEditorInputWithFragment(input2));
    }

    public static String toPlatformResource(IEditorInput input) {
        String uri = "";
        if (input instanceof FileEditorInput) {
            uri = ((FileEditorInput)input).getURI().toString();
        }
        if (input instanceof URIEditorInput) {
            uri = ((URIEditorInput)input).getURI().trimFragment().toString();
        }
        if (uri.startsWith("platform:/resource")) {
            return uri;
        }
        if (uri.startsWith("file:")) {
            uri = uri.replaceFirst("file:", "");
        }
        if (uri.startsWith(MDTUtil.getWorkspaceLocation().toString())) {
            uri = uri.replaceFirst(MDTUtil.getWorkspaceLocation().toString(), "");
            return "platform:/resource" + uri;
        }
        return uri;
    }

    public static String toPlatformResourceWithFragment(IEditorInput input) {
        String uri = "";
        if (input instanceof FileEditorInput) {
            uri = ((FileEditorInput)input).getURI().toString();
        }
        if (input instanceof URIEditorInput) {
            uri = ((URIEditorInput)input).getURI().toString();
        }
        if (uri.startsWith("platform:/resource")) {
            return uri;
        }
        if (uri.startsWith("file:")) {
            uri = uri.replaceFirst("file:", "");
        }
        if (uri.startsWith(MDTUtil.getWorkspaceLocation().toString())) {
            uri = uri.replaceFirst(MDTUtil.getWorkspaceLocation().toString(), "");
            return "platform:/resource" + uri;
        }
        return uri;
    }

    public boolean equals(Object o) {
        if (o instanceof IEditorInput) {
            return CachedResourcesEditorInput.checkSameEditorInput((IEditorInput)this, (IEditorInput)o);
        }
        return false;
    }
}

