/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.part;

import java.util.HashMap;
import org.eclipse.papyrus.diagram.common.part.CachedResourcesDocumentProvider;
import org.eclipse.papyrus.diagram.common.part.CachedResourcesEditorInput;
import org.eclipse.papyrus.diagram.common.util.PathsUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentProviderRegistry
extends HashMap<String, CachedResourcesDocumentProvider> {
    private static DocumentProviderRegistry instance = new DocumentProviderRegistry();

    public static DocumentProviderRegistry getInstance() {
        return instance;
    }

    private DocumentProviderRegistry() {
    }

    @Override
    public CachedResourcesDocumentProvider get(Object arg0) {
        throw new UnsupportedOperationException("Operation not supported. Use #get(String domainID, IEditorInput input)");
    }

    public CachedResourcesDocumentProvider get(String domainID, IEditorInput input) {
        String key = this.calculateKey(domainID, input);
        if (this.containsKey(key)) {
            return (CachedResourcesDocumentProvider)((Object)super.get(key));
        }
        CachedResourcesDocumentProvider documentProvider = new CachedResourcesDocumentProvider(domainID);
        this.put(key, documentProvider);
        return documentProvider;
    }

    private String calculateKey(String domainID, IEditorInput input) {
        String key = domainID;
        if (input instanceof FileEditorInput || input instanceof CachedResourcesEditorInput) {
            key = String.valueOf(key) + PathsUtil.getRelativeWorkspaceFromEditorInput(input);
        }
        return key;
    }
}

