/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.papyrus.diagram.common.Messages;
import org.eclipse.papyrus.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.diagram.common.service.PapyrusPaletteService;
import org.eclipse.papyrus.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteMenuAction
extends Action
implements IMenuCreator {
    protected PaletteViewer viewer;
    protected List<Action> actions;

    public PaletteMenuAction(PaletteViewer viewer) {
        this(viewer, false);
    }

    public PaletteMenuAction(PaletteViewer viewer, boolean hasIcon) {
        super(Messages.Palette_Action_Label);
        this.viewer = viewer;
        this.actions = this.createActions();
        this.setMenuCreator(this);
        this.setToolTipText(Messages.Palette_Action_Tooltip);
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    protected List<Action> createActions() {
        ArrayList<Action> list = new ArrayList<Action>();
        DisplayPaletteChangeAction action = null;
        IEditorPart part = this.getActiveSashPage();
        List<String> hiddenPalettes = PapyrusPalettePreferences.getHiddenPalettes(part);
        for (PapyrusPaletteService.ProviderDescriptor descriptor : PapyrusPaletteService.getInstance().getContributingProviders(part, this.getPaletteViewer().getPaletteRoot())) {
            action = new DisplayPaletteChangeAction(descriptor);
            String name = descriptor.getContributionName();
            if (name == null || name.equals("")) {
                name = descriptor.getContributionID();
            }
            String id = descriptor.getContributionID();
            action.setText(name);
            action.setChecked(!hiddenPalettes.contains(id));
            boolean requiredPlugins = PaletteUtil.areRequiredProfileApplied(part, descriptor);
            if (!requiredPlugins) {
                action.setEnabled(false);
                action.setToolTipText(Messages.PaletteContextMenu_MissingProfile);
            }
            list.add(action);
        }
        return list;
    }

    protected PaletteViewer getPaletteViewer() {
        return this.viewer;
    }

    protected IEditorPart getActiveSashPage() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        assert (editorPart != null);
        ISashWindowsContainer sashWindowsContainer = (ISashWindowsContainer)editorPart.getAdapter(ISashWindowsContainer.class);
        if (sashWindowsContainer != null) {
            return sashWindowsContainer.getActiveEditor();
        }
        return null;
    }

    public void dispose() {
    }

    protected Menu fillMenu(Menu menu) {
        for (Action action2 : this.actions) {
            DisplayPaletteChangeAction action = (DisplayPaletteChangeAction)action2;
            this.addActionToMenu(menu, (IAction)action);
        }
        this.setEnabled(!this.actions.isEmpty());
        return menu;
    }

    public Menu getMenu(Control parent) {
        return this.fillMenu(new Menu(parent));
    }

    public Menu getMenu(Menu parent) {
        return this.fillMenu(new Menu(parent));
    }

    public class DisplayPaletteChangeAction
    extends Action {
        private final PapyrusPaletteService.ProviderDescriptor providerDescriptor;

        public DisplayPaletteChangeAction(PapyrusPaletteService.ProviderDescriptor providerDescriptor) {
            this.providerDescriptor = providerDescriptor;
        }

        public PapyrusPaletteService.ProviderDescriptor getProviderDescriptor() {
            return this.providerDescriptor;
        }

        public void run() {
            PapyrusPalettePreferences.changePaletteVisibility(this.getProviderDescriptor().getContributionID(), PaletteMenuAction.this.getActiveSashPage().getClass().getName(), this.isChecked());
        }
    }
}

