/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.part;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.gef.ui.palette.customize.DrawerEntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.IPaletteState;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteCustomizerEx;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteDrawerState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.part.PapyrusPaletteEntryState;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusPaletteCustomizer
extends PaletteCustomizerEx {
    protected Map<PaletteEntry, PaletteContainer> changedParents = new HashMap<PaletteEntry, PaletteContainer>();
    private static final String PALETTE_CUSTOMIZATIONS_ID = "org.eclipse.gmf.runtime.diagram.ui.paletteCustomizations";
    private HashMap<PaletteEntry, IPaletteState> paletteStates = new HashMap();
    private IPreferenceStore preferences;

    public PapyrusPaletteCustomizer(IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.preferences = preferenceStore;
    }

    public Map<PaletteEntry, PaletteContainer> getChangedParents() {
        return this.changedParents;
    }

    public void applyCustomizationsToPalette(PaletteRoot paletteRoot) {
        XMLMemento rootMemento = this.getExistingCustomizations();
        if (rootMemento != null) {
            this.applyCustomizations((IMemento)rootMemento, (PaletteContainer)paletteRoot, (IMemento)rootMemento);
        }
    }

    protected void cleanPalette(PaletteContainer paletteContainer) {
        ArrayList<PaletteEntry> children = new ArrayList<PaletteEntry>(paletteContainer.getChildren().size());
        for (Object o : paletteContainer.getChildren()) {
            children.add((PaletteEntry)o);
        }
        for (PaletteEntry entry : children) {
            if (entry.getParent() != paletteContainer) {
                paletteContainer.getChildren().remove(entry);
            }
            if (!(entry instanceof PaletteContainer)) continue;
            this.cleanPalette((PaletteContainer)entry);
        }
    }

    protected IPaletteState createPaletteState(PaletteEntry entry) {
        if (entry instanceof PaletteDrawer) {
            return new PaletteDrawerState((PaletteDrawer)entry);
        }
        return new PapyrusPaletteEntryState(entry);
    }

    public EntryPage getPropertiesPage(PaletteEntry entry) {
        if (entry.getType().equals(PaletteDrawer.PALETTE_TYPE_DRAWER)) {
            return new PapyrusDrawerEntryPage();
        }
        return new PapyrusDefaultEntryPage();
    }

    public void storePaletteState(PaletteEntry entry) {
        if (this.paletteStates.get(entry) != null) {
            return;
        }
        IPaletteState paletteState = this.createPaletteState(entry);
        paletteState.storeState();
        this.paletteStates.put(entry, paletteState);
    }

    public void revertToSaved() {
        for (Map.Entry<PaletteEntry, IPaletteState> entry : this.paletteStates.entrySet()) {
            entry.getValue().rollback();
        }
        this.paletteStates.clear();
    }

    public void save() {
        if (this.paletteStates.isEmpty()) {
            return;
        }
        XMLMemento rootMemento = this.getExistingCustomizations();
        if (rootMemento == null) {
            rootMemento = XMLMemento.createWriteRoot((String)PALETTE_CUSTOMIZATIONS_ID);
        }
        for (Map.Entry<PaletteEntry, IPaletteState> entry : this.paletteStates.entrySet()) {
            IMemento memento = this.getMementoForEntry((IMemento)rootMemento, entry.getKey());
            if (memento == null) continue;
            entry.getValue().storeChangesInMemento(memento);
        }
        StringWriter writer = new StringWriter();
        try {
            rootMemento.save((Writer)writer);
            if (this.preferences != null) {
                this.preferences.setValue(PALETTE_CUSTOMIZATIONS_ID, writer.toString());
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error while saving preferences for palette", e);
        }
        this.paletteStates.clear();
    }

    private IMemento getMementoForEntry(IMemento rootMemento, PaletteEntry paletteEntry) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(paletteEntry.getId());
        PaletteContainer parent = this.changedParents.get(paletteEntry);
        if (parent == null) {
            parent = paletteEntry.getParent();
        }
        while (parent != null && !PaletteRoot.PALETTE_TYPE_ROOT.equals(parent.getType())) {
            idList.add(parent.getId());
            parent = parent.getParent();
        }
        IMemento containerMemento = rootMemento;
        int i = idList.size() - 1;
        while (i >= 0) {
            String id = (String)idList.get(i);
            IMemento memento = containerMemento.getChild(id);
            if (memento == null) {
                try {
                    memento = containerMemento.createChild(id);
                }
                catch (Exception e) {
                    Activator.getDefault().logError("Error while reading preferences for palette", e);
                    return null;
                }
            }
            containerMemento = memento;
            --i;
        }
        return containerMemento;
    }

    private void applyCustomizations(IMemento containerMemento, PaletteContainer paletteContainer, IMemento rootMemento) {
        for (PaletteEntry entry : paletteContainer.getChildren()) {
            IMemento childMemento = containerMemento.getChild(entry.getId());
            if (childMemento == null) continue;
            if (this.isChangingParent(entry, childMemento)) {
                this.changedParents.put(entry, entry.getParent());
            }
            IPaletteState state = this.createPaletteState(entry);
            state.applyChangesFromMemento(childMemento);
            if (!(entry instanceof PaletteContainer)) continue;
            this.applyCustomizations(childMemento, (PaletteContainer)entry, rootMemento);
        }
    }

    protected boolean isChangingParent(PaletteEntry entry, IMemento childMemento) {
        String parentId = childMemento.getString("parent");
        if (parentId == null) {
            return false;
        }
        return !entry.getParent().getId().equals(parentId);
    }

    private XMLMemento getExistingCustomizations() {
        String sValue;
        if (this.preferences != null && (sValue = this.preferences.getString(PALETTE_CUSTOMIZATIONS_ID)) != null && !sValue.equals("")) {
            try {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            catch (WorkbenchException e) {
                Activator.getDefault().logError("Error while reading preferences for palette", e);
            }
        }
        return null;
    }

    private class PapyrusDefaultEntryPage
    extends DefaultEntryPage {
        private PapyrusDefaultEntryPage() {
        }

        protected void handleDescriptionChanged(String text) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handleDescriptionChanged(text);
        }

        protected void handleHiddenSelected(boolean isChecked) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handleHiddenSelected(isChecked);
        }

        protected void handleNameChanged(String text) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handleNameChanged(text);
        }
    }

    public class PapyrusDrawerEntryPage
    extends DrawerEntryPage {
        protected void handleOpenSelected(boolean selection) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handleOpenSelected(selection);
        }

        protected void handlePinSelected(boolean selection) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handlePinSelected(selection);
        }

        protected void handleDescriptionChanged(String text) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handleDescriptionChanged(text);
        }

        protected void handleHiddenSelected(boolean isChecked) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handleHiddenSelected(isChecked);
        }

        protected void handleNameChanged(String text) {
            PapyrusPaletteCustomizer.this.storePaletteState(this.getEntry());
            super.handleNameChanged(text);
        }
    }
}

