/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.part;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.papyrus.diagram.common.part.IPaletteDescription;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusPaletteDescription
implements IPaletteDescription {
    private String name;
    private String contributionEditorID;
    private Object contributions;
    private String paletteID;
    private ProviderPriority priority;
    private Map<String, String> properties;

    public static IPaletteDescription create(IMemento memento) {
        PapyrusPaletteDescription description = new PapyrusPaletteDescription();
        description.setName(memento.getString("name"));
        description.setPaletteID(memento.getString("id"));
        description.setContributionEditorID(memento.getString("editorID"));
        description.setContributions(memento.getString("path"));
        description.setPriority(ProviderPriority.parse((String)memento.getString("priority")));
        IMemento propertiesMemento = memento.getChild("properties");
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propertiesMemento != null) {
            String[] stringArray = propertiesMemento.getAttributeKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                properties.put(key, propertiesMemento.getString(key));
                ++n2;
            }
        }
        description.setProperties(properties);
        return description;
    }

    @Override
    public String getContributionEditorID() {
        return this.contributionEditorID;
    }

    @Override
    public Object getContributions() {
        return this.contributions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContributionEditorID(String contributionEditorID) {
        this.contributionEditorID = contributionEditorID;
    }

    public void setContributions(Object contributions) {
        this.contributions = contributions;
    }

    public void setPaletteID(String paletteID) {
        this.paletteID = paletteID;
    }

    @Override
    public String getPaletteID() {
        return this.paletteID;
    }

    @Override
    public ProviderPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ProviderPriority priority) {
        this.priority = priority;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

