/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.part;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.core.utils.PapyrusTrace;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.part.IPaletteDescription;
import org.eclipse.papyrus.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.diagram.common.part.PapyrusPaletteDescription;
import org.eclipse.papyrus.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.diagram.common.service.PapyrusPaletteService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusPalettePreferences
implements IPapyrusPaletteConstant {
    public static List<IPaletteDescription> getLocalPalettes() {
        ArrayList<IPaletteDescription> paletteDescriptions = new ArrayList<IPaletteDescription>();
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingLocalPalettes();
        if (rootMemento == null) {
            return paletteDescriptions;
        }
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            IPaletteDescription description = PapyrusPaletteDescription.create(memento);
            paletteDescriptions.add(description);
            ++n2;
        }
        return paletteDescriptions;
    }

    protected static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected static XMLMemento getExistingCustomizations() {
        String sValue = PapyrusPalettePreferences.getPreferenceStore().getString("paletteCustomization");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"paletteCustomization");
        }
        catch (WorkbenchException e) {
            Activator.getDefault().logError("Impossible to read preferences", e);
            return null;
        }
    }

    protected static XMLMemento getLocalRedefinitions() {
        String sValue = PapyrusPalettePreferences.getPreferenceStore().getString("paletteRedefinitions");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"paletteRedefinitions");
        }
        catch (WorkbenchException e) {
            Activator.getDefault().logError("Impossible to read preferences for palette local redefinitions", e);
            return null;
        }
    }

    public static IMemento registerLocalRedefinition(String paletteID, String path) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getLocalRedefinitions();
        IMemento memento = PapyrusPalettePreferences.getPaletteRedefinitionNode(paletteID);
        if (memento != null) {
            PapyrusPalettePreferences.unregisterLocalRedefinition(paletteID);
        }
        IMemento newMemento = rootMemento.createChild("paletteRedefinition");
        newMemento.putString("id", paletteID);
        newMemento.putString("path", path);
        PapyrusPalettePreferences.saveLocalRedefinitions(rootMemento);
        return newMemento;
    }

    public static void unregisterLocalRedefinition(String paletteID) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getLocalRedefinitions();
        XMLMemento newRootMemento = XMLMemento.createWriteRoot((String)"paletteRedefinitions");
        IMemento[] iMementoArray = rootMemento.getChildren("paletteRedefinition");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (!memento.getString("id").equals(paletteID)) {
                newRootMemento.putMemento(memento);
            }
            ++n2;
        }
        PapyrusPalettePreferences.saveLocalRedefinitions(newRootMemento);
    }

    private static void saveMemento(XMLMemento xmlMemento, String key) {
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save((Writer)writer);
            if (PapyrusPalettePreferences.getPreferenceStore() != null) {
                PapyrusPalettePreferences.getPreferenceStore().setValue(key, writer.toString());
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("input/ouput exception", e);
        }
    }

    public static void saveLocalRedefinitions(XMLMemento rootMemento) {
        PapyrusPalettePreferences.saveMemento(rootMemento, "paletteRedefinitions");
    }

    public static void saveCustomizations(XMLMemento rootMemento) {
        PapyrusPalettePreferences.saveMemento(rootMemento, "paletteCustomization");
    }

    public static void saveLocalPalettes(XMLMemento rootMemento) {
        PapyrusPalettePreferences.saveMemento(rootMemento, "localPaletteDefinition");
    }

    protected static IMemento getEditorMemento(XMLMemento rootMemento, String currentEditorClass) {
        IMemento[] editorsMementos;
        IMemento[] iMementoArray = editorsMementos = rootMemento.getChildren("editor");
        int n = editorsMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento editorMemento = iMementoArray[n2];
            String editorClass = editorMemento.getString("class");
            if (currentEditorClass.equals(editorClass)) {
                return editorMemento;
            }
            ++n2;
        }
        IMemento memento = rootMemento.createChild("editor");
        memento.putString("class", currentEditorClass);
        return memento;
    }

    public static IMemento getEditorHiddenPalettesMemento(IMemento editorMemento) {
        IMemento hiddenPaletteMemento = editorMemento.getChild("hiddenPalettes");
        if (hiddenPaletteMemento == null) {
            hiddenPaletteMemento = editorMemento.createChild("hiddenPalettes");
        }
        return hiddenPaletteMemento;
    }

    public static String getHiddenPalettes(IMemento hiddenPalettesMemento) {
        return hiddenPalettesMemento.getString("id");
    }

    public static String getPaletteRedefinition(String paletteID) {
        IMemento memento;
        if (paletteID == null) {
            Activator.log.debug("Trying to find preferences for a null palette identifier");
        }
        if ((memento = PapyrusPalettePreferences.getPaletteRedefinitionNode(paletteID)) != null) {
            return memento.getString("path");
        }
        return null;
    }

    private static IMemento getPaletteRedefinitionNode(String paletteID) {
        IMemento[] redefinitions;
        XMLMemento rootMemento = PapyrusPalettePreferences.getLocalRedefinitions();
        IMemento[] iMementoArray = redefinitions = rootMemento.getChildren("paletteRedefinition");
        int n = redefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento redefinitionMemento = iMementoArray[n2];
            String paletteNodeID = redefinitionMemento.getString("id");
            if (paletteID.equals(paletteNodeID)) {
                return redefinitionMemento;
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getHiddenPalettesList(IMemento hiddenPalettesMemento) {
        String hiddenPalettes = hiddenPalettesMemento.getString("id");
        ArrayList<String> ids = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(hiddenPalettes != null ? hiddenPalettes : "", ";");
        while (tokenizer.hasMoreTokens()) {
            ids.add(tokenizer.nextToken());
        }
        return ids;
    }

    public static void changePaletteVisibility(String providerID, IEditorPart editorClass, boolean visible) {
        PapyrusPalettePreferences.changePaletteVisibility(providerID, PapyrusPalettePreferences.getEditorClassName(editorClass), visible);
    }

    protected static String getEditorClassName(IEditorPart editorClass) {
        return editorClass.getClass().getName();
    }

    public static void changePaletteVisibility(String providerID, String editorClass, boolean visible) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingCustomizations();
        IMemento editorMemento = PapyrusPalettePreferences.getEditorMemento(rootMemento, editorClass);
        IMemento hiddenPalettesMemento = PapyrusPalettePreferences.getEditorHiddenPalettesMemento(editorMemento);
        List<String> hiddenPalettes = PapyrusPalettePreferences.getHiddenPalettesList(hiddenPalettesMemento);
        if (hiddenPalettes.contains(providerID) && visible) {
            hiddenPalettes.remove(providerID);
        } else if (!hiddenPalettes.contains(providerID) && !visible) {
            hiddenPalettes.add(providerID);
        }
        String newIDs = PapyrusPalettePreferences.serializeHiddenPalettes(hiddenPalettes);
        hiddenPalettesMemento.putString("id", newIDs);
        PapyrusPalettePreferences.saveCustomizations(rootMemento);
    }

    public static List<String> getHiddenPalettes(IEditorPart part) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingCustomizations();
        IMemento editorMemento = PapyrusPalettePreferences.getEditorMemento(rootMemento, part.getClass().getName());
        IMemento hiddenPalettesMemento = PapyrusPalettePreferences.getEditorHiddenPalettesMemento(editorMemento);
        return PapyrusPalettePreferences.getHiddenPalettesList(hiddenPalettesMemento);
    }

    protected static String serializeHiddenPalettes(List<String> hiddenPalettes) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> it = hiddenPalettes.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(";");
        }
        return buffer.toString();
    }

    protected static XMLMemento getExistingLocalPalettes() {
        String sValue = PapyrusPalettePreferences.getPreferenceStore().getString("localPaletteDefinition");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"localPaletteDefinition");
        }
        catch (WorkbenchException e) {
            Activator.getDefault().logError("Impossible to read preferences", e);
            return null;
        }
    }

    public static void addLocalPalette(String paletteID, String paletteName, ProviderPriority priority, String editorID, Set<String> requiredProfiles) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingLocalPalettes();
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        paletteMemento.putString("name", paletteName);
        paletteMemento.putString("priority", priority.getName());
        paletteMemento.putString("editorID", editorID);
        paletteMemento.putString("path", PapyrusPalettePreferences.getPalettePathFromID(paletteID));
        IMemento propertiesMemento = paletteMemento.createChild("properties");
        propertiesMemento.putString("requiredProfiles", PaletteUtil.getSerializedProfileListFromSet(requiredProfiles));
        PapyrusPalettePreferences.saveLocalPalettes(rootMemento);
    }

    public static ProviderPriority getPalettePriority(String paletteID) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingLocalPalettes();
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, paletteID);
        if (paletteMemento == null) {
            paletteMemento = PapyrusPalettePreferences.createMemento(rootMemento, paletteID);
        }
        String palettePriority = paletteMemento.getString("priority");
        return ProviderPriority.parse((String)palettePriority);
    }

    public static void deleteLocalPalette(String id) {
        XMLMemento rootMemento = PapyrusPalettePreferences.getExistingLocalPalettes();
        IMemento paletteMemento = PapyrusPalettePreferences.searchPaletteMemento(rootMemento, id);
        if (paletteMemento == null) {
            PapyrusTrace.log((int)2, (String)("impossible to find the palette with id: " + id));
            return;
        }
        XMLMemento newRootMemento = XMLMemento.createWriteRoot((String)"localPaletteDefinition");
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (!memento.getString("id").equals(paletteMemento.getString("id"))) {
                IMemento newChild = newRootMemento.createChild("palette");
                newChild.putMemento(memento);
            }
            ++n2;
        }
        PapyrusPalettePreferences.saveLocalPalettes(newRootMemento);
    }

    public static String getPalettePathFromID(String paletteID) {
        return "Palette_" + paletteID + ".xml";
    }

    protected static IMemento createMemento(XMLMemento rootMemento, String paletteID) {
        IMemento memento = rootMemento.createChild("palette");
        memento.putString("id", paletteID);
        return memento;
    }

    protected static IMemento searchPaletteMemento(XMLMemento rootMemento, String paletteID) {
        IMemento[] iMementoArray = rootMemento.getChildren("palette");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            String id = memento.getString("id");
            if (paletteID.equals(id)) {
                return memento;
            }
            ++n2;
        }
        return null;
    }

    public static void createPaletteRedefinition(PapyrusPaletteService.ExtendedProviderDescriptor descriptor) {
        String path = null;
        path = descriptor.createLocalRedefinition();
        if (path == null) {
            Activator.log.error("There was an error during creation of the local file", null);
            return;
        }
        PapyrusPalettePreferences.registerLocalRedefinition(descriptor.getContributionID(), path);
    }
}

