/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.diagram.common.providers.RootViewInfo;
import org.eclipse.papyrus.diagram.common.providers.ViewInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseViewInfo
implements ViewInfo {
    private ViewInfo parentViewInfo = null;
    public String visualID = "-1";
    public String type;
    private int typeViewInfo = -1;
    public String label = null;
    private Collection<ViewInfo> children = null;
    private static Map<Integer, Collection<ViewInfo>> toAdd = null;
    public String elementType;
    public String parent;
    public RootViewInfo rootViewInfo;
    public Boolean selectable = true;

    public BaseViewInfo() {
    }

    public BaseViewInfo(int visualID, int type, String label) {
        this(visualID, type, label, null, null);
    }

    public BaseViewInfo(int visualID, int type, String label, Collection<ViewInfo> children, ViewInfo parent) {
        this.visualID = String.valueOf(visualID);
        this.typeViewInfo = type;
        this.label = label;
        this.children = children;
        this.parentViewInfo = parent;
    }

    @Override
    public Collection<ViewInfo> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ViewInfo>();
        }
        return this.children;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getType() {
        switch (this.typeViewInfo) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                return this.typeViewInfo;
            }
        }
        if (this.type != null && this.type.length() > 0) {
            if ("None".equals(this.type)) {
                return -1;
            }
            if ("Head".equals(this.type)) {
                return 0;
            }
            if ("Node".equals(this.type)) {
                return 2;
            }
            if ("Edge".equals(this.type)) {
                return 3;
            }
            if ("Label".equals(this.type)) {
                return 4;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int getVisualID() {
        return Integer.valueOf(this.visualID);
    }

    @Override
    public ViewInfo getParent() {
        return this.parentViewInfo;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    protected static Map<Integer, Collection<ViewInfo>> getToAdd() {
        if (toAdd == null) {
            toAdd = new HashMap<Integer, Collection<ViewInfo>>();
        }
        return toAdd;
    }

    @Override
    public void setChildren(Collection<ViewInfo> children) {
        this.children = children;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setParent(ViewInfo parent) {
        this.parentViewInfo = parent;
    }

    @Override
    public void setType(int type) {
        this.typeViewInfo = type;
    }

    @Override
    public void setVisualID(int visualID) {
        this.visualID = String.valueOf(visualID);
    }

    protected ViewInfo getRootInfo() {
        ViewInfo parent = null;
        ViewInfo aux = this;
        while ((parent = aux.getParent()) != null) {
            aux = parent;
        }
        return aux;
    }

    protected boolean isRoot() {
        ViewInfo root = this.getRootInfo();
        return root != null && root == this;
    }

    @Override
    public boolean addNode(int parentVisualID, ViewInfo info) {
        if (this.isAlreadyContained(info)) {
            return true;
        }
        if (this.internalAddNode(parentVisualID, info)) {
            if (this.isRoot()) {
                this.revisePendentNodes(info);
            }
            return true;
        }
        if (this.isRoot()) {
            this.addPendentNode(parentVisualID, info);
        }
        return false;
    }

    protected boolean isAlreadyContained(ViewInfo info) {
        if (info == null) {
            return true;
        }
        return this.lookInChildren(this, info);
    }

    protected boolean lookInChildren(ViewInfo info, ViewInfo lookFor) {
        if (info == lookFor) {
            return true;
        }
        for (ViewInfo child : info.getChildren()) {
            if (!this.lookInChildren(child, lookFor)) continue;
            return true;
        }
        return false;
    }

    private void addPendentNode(int parentID, ViewInfo info) {
        Map<Integer, Collection<ViewInfo>> toAdd = BaseViewInfo.getToAdd();
        if (!toAdd.containsKey(parentID)) {
            toAdd.put(parentID, new ArrayList());
        }
        if (!toAdd.get(parentID).contains(info)) {
            toAdd.get(parentID).add(info);
        }
    }

    private void revisePendentNodes(ViewInfo info) {
        int parentVisualID = info.getVisualID();
        Map<Integer, Collection<ViewInfo>> toAdd = BaseViewInfo.getToAdd();
        if (toAdd.containsKey(parentVisualID)) {
            for (ViewInfo viewInfo : toAdd.get(parentVisualID)) {
                if (info.getChildren().contains(viewInfo) || info == viewInfo || this.isAlreadyContained(viewInfo)) continue;
                info.getChildren().add(viewInfo);
                if (viewInfo.getParent() != null) continue;
                viewInfo.setParent(info);
            }
            toAdd.remove(parentVisualID);
        }
    }

    protected boolean internalAddNode(int parentVisualID, ViewInfo info) {
        if (info == null) {
            return true;
        }
        if (this.getVisualID() == parentVisualID) {
            if (!this.getChildren().contains(info) && this != info) {
                this.getChildren().add(info);
            }
            if (info.getParent() == null) {
                info.setParent(this);
            }
            return true;
        }
        for (ViewInfo viewInfo : this.getChildren()) {
            if (!viewInfo.addNode(parentVisualID, info)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String superString = super.toString();
        String myString = String.valueOf(this.getVisualID()) + ", " + this.getLabel();
        superString = superString != null ? String.valueOf(superString) + " :: " + myString : myString;
        return superString;
    }
}

