/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.util.Util;
import org.eclipse.papyrus.umlutils.ImageUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class EditorLabelProvider
implements ILabelProvider {
    private final Map<String, Integer> index = new HashMap<String, Integer>();
    public static final String pluginID = "org.eclipse.uml2.uml.edit";
    public static final String imageFolder = "/icons/full/obj16/";
    public static final Image imageNotFound = Activator.getPluginIconImage("org.eclipse.uml2.uml.edit", "notFound.gif");
    public static final String ICON_METACLASS = "/icons/Metaclass.gif";
    public static final String ICON_COMPARTMENT = "/icons/none_comp_vis.gif";

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        EObject eObject;
        if (!(element instanceof EObject) && element instanceof IAdaptable && (eObject = (EObject)((IAdaptable)element).getAdapter(EObject.class)) != null) {
            element = eObject;
        }
        if (element instanceof Class && Util.isMetaclass((Type)element)) {
            return Activator.getPluginIconImage("org.eclipse.papyrus.diagram.common", ICON_METACLASS);
        }
        if (element instanceof Element) {
            Image im = Activator.getIconElement((Element)element);
            String imagePath = new String(imageFolder);
            if (im == null) {
                imagePath = String.valueOf(imagePath) + element.getClass().getSimpleName() + ".gif";
                imagePath = imagePath.replace("Impl", "");
                im = Activator.getPluginIconImage(pluginID, imagePath);
            }
            if (im.equals((Object)imageNotFound)) {
                return null;
            }
            return im;
        }
        if (element instanceof BasicCompartment || element instanceof DecorationNode) {
            return Activator.getPluginIconImage("org.eclipse.papyrus.diagram.common", ICON_COMPARTMENT);
        }
        if (element instanceof Diagram) {
            IPageIconsRegistry registry = null;
            try {
                registry = (IPageIconsRegistry)ServiceUtilsForActionHandlers.getInstance().getServiceRegistry().getService(IPageIconsRegistry.class);
            }
            catch (ServiceException imagePath) {
                // empty catch block
            }
            if (registry == null) {
                registry = new PageIconsRegistry();
            }
            return registry.getEditorIcon(element);
        }
        if (element instanceof EObject) {
            IConfigurationElement[] extensions;
            eObject = (EObject)element;
            IItemLabelProvider itemLabelProvider = null;
            String uri = eObject.eClass().getEPackage().getNsURI();
            AdapterFactory adapterFactory = null;
            IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.edit.itemProviderAdapterFactories");
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (uri.equals(e.getAttribute("uri"))) {
                    try {
                        adapterFactory = (AdapterFactory)e.createExecutableExtension("class");
                    }
                    catch (CoreException ex) {
                        Activator.log.error((Throwable)ex);
                    }
                    if (adapterFactory != null) break;
                }
                ++n2;
            }
            if (adapterFactory != null) {
                itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            }
            if (itemLabelProvider != null) {
                Object imageObject = itemLabelProvider.getImage((Object)eObject);
                return ExtendedImageRegistry.getInstance().getImage(imageObject);
            }
            return null;
        }
        return null;
    }

    public String getText(Object element) {
        EObject eObject;
        if (element == null) {
            return "<Undefined>";
        }
        if (!(element instanceof EObject) && element instanceof IAdaptable && (eObject = (EObject)((IAdaptable)element).getAdapter(EObject.class)) != null) {
            element = eObject;
        }
        if (element instanceof EObject && UMLUtil.getBaseElement((EObject)((EObject)element)) != null) {
            return this.getText(UMLUtil.getBaseElement((EObject)((EObject)element)));
        }
        if (element instanceof org.eclipse.uml2.uml.Image) {
            org.eclipse.uml2.uml.Image image = (org.eclipse.uml2.uml.Image)element;
            String imageName = ImageUtil.getName((org.eclipse.uml2.uml.Image)image);
            String location = image.getLocation();
            if (this.isEmptyString(imageName)) {
                if (this.isEmptyString(location)) {
                    return "Image";
                }
                return location;
            }
            if (this.isEmptyString(location)) {
                return imageName;
            }
            return String.valueOf(imageName) + " : " + location;
        }
        if (element instanceof PackageImport) {
            Package importedPackage = ((PackageImport)element).getImportedPackage();
            if (importedPackage == null) {
                return "<Package Import>";
            }
            return "<Package Import> " + importedPackage.getName();
        }
        if (element instanceof ElementImport) {
            PackageableElement importedElement = ((ElementImport)element).getImportedElement();
            if (importedElement == null) {
                return "<Element Import>";
            }
            return "<Element Import> " + importedElement.getName();
        }
        if (element instanceof NamedElement) {
            if (element instanceof ValueSpecification) {
                String value = null;
                if (element instanceof InstanceValue) {
                    InstanceSpecification specification = ((InstanceValue)element).getInstance();
                    if (specification != null) {
                        value = this.getText(specification);
                    }
                } else {
                    value = element instanceof LiteralString ? "\"" + ((ValueSpecification)element).stringValue() + "\"" : (element instanceof LiteralNull ? "null" : ((ValueSpecification)element).stringValue());
                }
                if (value != null) {
                    if (((NamedElement)element).isSetName()) {
                        return String.valueOf(((NamedElement)element).getName()) + "=" + value;
                    }
                    return value;
                }
                if (((NamedElement)element).isSetName()) {
                    return ((NamedElement)element).getName();
                }
                return "";
            }
            return ((NamedElement)element).getName();
        }
        if (element instanceof Element) {
            String className = element.getClass().getName();
            int i = className.lastIndexOf(".");
            className = className.substring(i + 1);
            Integer number = this.index.get(className = className.replace("Impl", ""));
            if (number == null) {
                number = 0;
            }
            this.index.put(className, number + 1);
            return String.valueOf(className) + " " + number;
        }
        if (element instanceof Diagram) {
            return ((Diagram)element).getName();
        }
        if (element instanceof View) {
            IGraphicalEditPart dummyEP = EditPartService.getInstance().createGraphicEditPart((View)element);
            if (dummyEP instanceof ResizableCompartmentEditPart) {
                return ((ResizableCompartmentEditPart)dummyEP).getCompartmentName();
            }
        } else if (element instanceof EClass) {
            return ((EClass)element).getName();
        }
        return element.toString();
    }

    private boolean isEmptyString(String s) {
        return s == null || s.trim().equals("");
    }

    public void dispose() {
    }
}

