/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.validation.ValidationUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public abstract class ValidationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    protected static final String KEY = "validationStatus";
    private static final String MARKER_TYPE = "org.eclipse.papyrus.diagram.common.diagnostic";
    private static Map<TransactionalEditingDomain, MarkerObserver> fileObservers = new HashMap<TransactionalEditingDomain, MarkerObserver>();
    private static Map<String, IDecorator> allDecorators = new HashMap<String, IDecorator>();

    public abstract void createDecorators(IDecoratorTarget var1);

    public abstract boolean provides(IOperation var1);

    public static void refreshDecorators(View view) {
        ValidationDecoratorProvider.refreshDecorators(ViewUtil.getIdStr((View)view), TransactionUtil.getEditingDomain((EObject)view));
    }

    private static void refreshDecorators(String viewId, final TransactionalEditingDomain domain) {
        IDecorator decorator;
        IDecorator iDecorator = decorator = viewId != null ? allDecorators.get(viewId) : null;
        if (decorator == null || domain == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    domain.runExclusive(new Runnable(){

                        public void run() {
                            decorator.refresh();
                        }
                    });
                }
                catch (Exception e) {
                    Activator.log.error("Decorator refresh failure", (Throwable)e);
                }
            }
        });
    }

    static class MarkerObserver
    implements IFileObserver {
        private TransactionalEditingDomain domain;
        private EList<View> views = new BasicEList();

        private MarkerObserver(TransactionalEditingDomain domain) {
            this.domain = domain;
        }

        public void handleFileRenamed(IFile oldFile, IFile file) {
        }

        public void handleFileMoved(IFile oldFile, IFile file) {
        }

        public void handleFileDeleted(IFile file) {
        }

        public void handleFileChanged(IFile file) {
        }

        public void handleMarkerAdded(IMarker marker) {
            this.handleMarkerChanged(marker);
        }

        public void handleMarkerDeleted(IMarker marker, Map attributes) {
            String viewId = (String)attributes.get("elementId");
            if (viewId != null) {
                ValidationDecoratorProvider.refreshDecorators(viewId, this.domain);
            } else {
                EObject eObjectFromMarker = ValidationUtils.eObjectFromMarkerOrMap(null, (Map)attributes, (EditingDomain)this.domain);
                if (eObjectFromMarker != null) {
                    for (View view : CrossReferencerUtil.getCrossReferencingViews(eObjectFromMarker, null)) {
                        ValidationDecoratorProvider.refreshDecorators(view);
                    }
                }
            }
        }

        public void handleMarkerChanged(IMarker marker) {
            try {
                EObject eObjectFromMarker;
                if (this.getType(marker).equals(ValidationDecoratorProvider.MARKER_TYPE)) {
                    String viewId = marker.getAttribute("elementId", "");
                    ValidationDecoratorProvider.refreshDecorators(viewId, this.domain);
                } else if (marker.isSubtypeOf("org.eclipse.emf.ecore.diagnostic") && (eObjectFromMarker = ValidationUtils.eObjectFromMarkerOrMap((IMarker)marker, null, (EditingDomain)this.domain)) != null) {
                    for (View view : CrossReferencerUtil.getCrossReferencingViews(eObjectFromMarker, null)) {
                        ValidationDecoratorProvider.refreshDecorators(view);
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        private String getType(IMarker marker) {
            try {
                return marker.getType();
            }
            catch (CoreException e) {
                Activator.log.error("Validation marker refresh failure", (Throwable)e);
                return "";
            }
        }
    }

    public static class StatusDecorator
    extends AbstractDecorator {
        private String viewId;
        private TransactionalEditingDomain editingDomain;

        public StatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
            try {
                final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
                TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                    public void run() {
                        StatusDecorator.this.viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                        StatusDecorator.this.editingDomain = TransactionUtil.getEditingDomain((EObject)view);
                    }
                });
            }
            catch (Exception e) {
                Activator.log.error("ViewID access failure", (Throwable)e);
            }
        }

        public void refresh() {
            this.removeDecoration();
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getViewer() == null) {
                return;
            }
            String elementId = ViewUtil.getIdStr((View)view);
            if (elementId == null) {
                return;
            }
            int severity = 0;
            IMarker foundMarker = null;
            IFile gmfResource = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            if (gmfResource == null || !gmfResource.exists()) {
                return;
            }
            IFile emfResource = null;
            if (view.getElement() != null) {
                emfResource = WorkspaceSynchronizer.getFile((Resource)view.getElement().eResource());
            }
            IMarker[] gmfMarkers = null;
            IMarker[] emfMarkers = new IMarker[]{};
            try {
                gmfMarkers = gmfResource.findMarkers(ValidationDecoratorProvider.MARKER_TYPE, true, 2);
                if (emfResource != null) {
                    emfMarkers = emfResource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                }
            }
            catch (CoreException e) {
                Activator.log.error("Validation markers refresh failure", (Throwable)e);
            }
            if (gmfMarkers == null) {
                return;
            }
            Label toolTip = null;
            int i = 0;
            while (i < gmfMarkers.length + emfMarkers.length) {
                IMarker marker;
                boolean markerIsForMe = false;
                if (i < gmfMarkers.length) {
                    marker = gmfMarkers[i];
                    String attribute = marker.getAttribute("elementId", "");
                    markerIsForMe = attribute.equals(elementId);
                } else {
                    marker = emfMarkers[i - gmfMarkers.length];
                    EObject eObjectOfMarker = ValidationUtils.eObjectFromMarkerOrMap((IMarker)marker, null, (EditingDomain)this.editingDomain);
                    boolean bl = markerIsForMe = eObjectOfMarker == view.getElement();
                }
                if (markerIsForMe) {
                    int nextSeverity = marker.getAttribute("severity", 0);
                    Image nextImage = this.getImage(nextSeverity);
                    if (foundMarker == null) {
                        foundMarker = marker;
                        toolTip = new Label(marker.getAttribute("message", ""), nextImage);
                    } else {
                        if (toolTip.getChildren().isEmpty()) {
                            Label comositeLabel = new Label();
                            FlowLayout fl = new FlowLayout(false);
                            fl.setMinorSpacing(0);
                            comositeLabel.setLayoutManager((LayoutManager)fl);
                            comositeLabel.add((IFigure)toolTip);
                            toolTip = comositeLabel;
                        }
                        toolTip.add((IFigure)new Label(marker.getAttribute("message", ""), nextImage));
                    }
                    severity = nextSeverity > severity ? nextSeverity : severity;
                }
                ++i;
            }
            if (foundMarker == null) {
                return;
            }
            if (editPart instanceof GraphicalEditPart) {
                if (view instanceof Edge) {
                    this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(this.getImage(severity), 50, true));
                } else {
                    int margin = -1;
                    if (editPart instanceof GraphicalEditPart) {
                        margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                    }
                    this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.getImage(severity), IDecoratorTarget.Direction.NORTH_EAST, margin, true));
                }
                this.getDecoration().setToolTip(toolTip);
            }
        }

        private Image getImage(int severity) {
            String imageName = "IMG_OBJS_ERROR_TSK";
            switch (severity) {
                case 2: {
                    imageName = "IMG_OBJS_ERROR_TSK";
                    break;
                }
                case 1: {
                    imageName = "IMG_OBJS_WARN_TSK";
                    break;
                }
                default: {
                    imageName = "IMG_OBJS_INFO_TSK";
                }
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
        }

        public void activate() {
            View view;
            MarkerObserver fileObserver;
            if (this.viewId == null) {
                return;
            }
            IDecorator decorator = (IDecorator)allDecorators.get(this.viewId);
            if (decorator == null) {
                allDecorators.put(this.viewId, this);
            }
            if ((fileObserver = (MarkerObserver)fileObservers.get(this.editingDomain)) == null) {
                fileObserver = new MarkerObserver(this.editingDomain);
                fileObservers.put(this.editingDomain, fileObserver);
                FileChangeManager.getInstance().addFileObserver((IFileObserver)fileObserver);
            }
            if ((view = (View)this.getDecoratorTarget().getAdapter(View.class)) != null && !fileObserver.views.contains((Object)view)) {
                fileObserver.views.add((Object)view);
            }
        }

        public void deactivate() {
            if (this.viewId == null) {
                return;
            }
            allDecorators.remove(this.viewId);
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || this.editingDomain == null) {
                super.deactivate();
                return;
            }
            MarkerObserver fileObserver = (MarkerObserver)fileObservers.get(this.editingDomain);
            if (fileObserver != null) {
                fileObserver.views.remove((Object)view);
                if (fileObserver.views.isEmpty()) {
                    FileChangeManager.getInstance().removeFileObserver((IFileObserver)fileObserver);
                    fileObservers.remove(this.editingDomain);
                }
            }
            super.deactivate();
        }
    }
}

