/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.providers.assistant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.papyrus.diagram.common.providers.assistant.Assistant;
import org.eclipse.papyrus.diagram.common.providers.assistant.AssistedEditPart;
import org.eclipse.papyrus.diagram.common.providers.assistant.ElementType;
import org.eclipse.papyrus.diagram.common.providers.assistant.Exclude;
import org.eclipse.papyrus.diagram.common.providers.assistant.Include;
import org.eclipse.papyrus.diagram.common.util.ExtensionPointParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingAssistantRegistry {
    private static final ModelingAssistantRegistry Instance = new ModelingAssistantRegistry();
    private static final String modelingAssistantExtensionPointID = "org.eclipse.papyrus.diagram.common.editorAssistantProvider";
    private static final Class<Object>[] classes = new Class[]{Assistant.class, AssistedEditPart.class, Include.class, Exclude.class, ElementType.class};
    private static final Map<String, List<Assistant>> mapEditorID2Assistant = new HashMap<String, List<Assistant>>();

    private ModelingAssistantRegistry() {
    }

    public static ModelingAssistantRegistry getInstance() {
        return Instance;
    }

    public List<Assistant> getAssistantForEditor(String editorID) {
        if (this.getMapEditorID2Assistant().containsKey(editorID)) {
            return this.getMapEditorID2Assistant().get(editorID);
        }
        return Collections.emptyList();
    }

    public Map<String, List<Assistant>> getMapEditorID2Assistant() {
        mapEditorID2Assistant.clear();
        ExtensionPointParser parser = new ExtensionPointParser(modelingAssistantExtensionPointID, classes);
        List<Object> extensions = parser.parseExtensionPoint();
        for (Object object : extensions) {
            Assistant assistant = (Assistant)Platform.getAdapterManager().getAdapter(object, Assistant.class);
            if (assistant == null || assistant.editorID == null) continue;
            if (!mapEditorID2Assistant.containsKey(assistant.editorID)) {
                mapEditorID2Assistant.put(assistant.editorID, new ArrayList());
            }
            mapEditorID2Assistant.get(assistant.editorID).add(assistant);
        }
        return mapEditorID2Assistant;
    }

    public List customizeTypesForEditPart(String editorID, EditPart editPart, List types) {
        for (Assistant assistant : this.getAssistantForEditor(editorID)) {
            if (assistant == null) continue;
            types = assistant.customizeTypesForEditPart(editPart, types);
        }
        return types;
    }
}

