/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.resourceupdate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.resourceloading.util.LoadingUtils;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.Messages;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartActivationListener
implements IPartListener {
    private IMultiDiagramEditor editor;
    private List<IPath> changedMainResourcePaths;
    private Map<IPath, ResourceModification> resourceModifications;

    public PartActivationListener(IMultiDiagramEditor editor) {
        this.editor = editor;
        this.resourceModifications = new HashMap<IPath, ResourceModification>();
        this.changedMainResourcePaths = new ArrayList<IPath>();
    }

    public boolean isModied() {
        return this.isMainModelModified();
    }

    public boolean isMainModelModified() {
        return !this.changedMainResourcePaths.isEmpty();
    }

    public boolean isModified(IPath resourcePathToTest) {
        return this.resourceModifications.containsKey(resourcePathToTest);
    }

    public void setModificationData(String changedResourcePath, IResourceDelta delta) {
        IPath path = Path.fromPortableString((String)changedResourcePath);
        this.setModificationData(path, delta, true, true);
    }

    public void setModificationData(IPath changedResourcePath, IResourceDelta delta, boolean isMainResource, boolean resourceConflicts) {
        if (this.resourceModifications.containsKey(changedResourcePath)) {
            ResourceModification resourceModification = this.resourceModifications.get(changedResourcePath);
            resourceModification.conflict = resourceModification.conflict | resourceConflicts;
            this.resourceModifications.get(changedResourcePath).delta = delta;
        }
        this.resourceModifications.put(changedResourcePath, new ResourceModification(delta, resourceConflicts));
        if (isMainResource) {
            this.changedMainResourcePaths.add(changedResourcePath);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        IMultiDiagramEditor activeEditor = EditorUtils.getMultiDiagramEditor();
        if (this.editor == activeEditor && !this.resourceModifications.isEmpty()) {
            int mainDeltaKinds = 0;
            if (!this.changedMainResourcePaths.isEmpty()) {
                for (IPath mainPath : this.changedMainResourcePaths) {
                    ResourceModification modif = this.resourceModifications.get(mainPath);
                    mainDeltaKinds |= modif.delta.getKind();
                }
            }
            int deltaKinds = 0;
            HashSet<String> addedModels = new HashSet<String>();
            HashSet<String> removedModels = new HashSet<String>();
            HashMap<String, Boolean> changedModels = new HashMap<String, Boolean>();
            block6: for (Map.Entry<IPath, ResourceModification> entry : this.resourceModifications.entrySet()) {
                IPath path = entry.getKey();
                ResourceModification modif = entry.getValue();
                deltaKinds |= modif.delta.getKind();
                switch (modif.delta.getKind()) {
                    case 1: {
                        addedModels.add(path.removeFileExtension().toString());
                        break;
                    }
                    case 2: {
                        removedModels.add(path.removeFileExtension().toString());
                        break;
                    }
                    case 4: {
                        String key = path.removeFileExtension().toString();
                        if (changedModels.containsKey(key) && ((Boolean)changedModels.get(key)).booleanValue()) continue block6;
                        changedModels.put(key, modif.conflict);
                        break;
                    }
                }
            }
            this.handleDeltaKinds(deltaKinds, addedModels, removedModels, changedModels, mainDeltaKinds);
            this.changedMainResourcePaths.clear();
            this.resourceModifications.clear();
        }
    }

    private void handleDeltaKinds(int deltaKinds, Set<String> addedModels, Set<String> removedModels, Map<String, Boolean> changedModels, int mainDeltaKinds) {
        if ((deltaKinds & 2) > 0) {
            String msg = "";
            String list = this.getModelsListString(removedModels);
            msg = removedModels.size() == 1 ? String.format(Messages.PartActivationListener_RemovedMsg_single, list) : String.format(Messages.PartActivationListener_RemovedMsg_many, list);
            MessageDialog.openInformation((Shell)new Shell(), (String)Messages.PartActivationListener_RemovedTitle, (String)msg);
        }
        if ((deltaKinds & 4) > 0) {
            boolean mainChanged = (mainDeltaKinds & 4) > 0;
            String msg = "";
            String list = this.getModelsListString(changedModels.keySet());
            msg = changedModels.size() == 1 && mainChanged ? String.format(Messages.PartActivationListener_ChangedMainMsg_single, list) : (mainChanged ? String.format(Messages.PartActivationListener_ChangedMainMsg_many, list) : (changedModels.size() == 1 ? String.format(Messages.PartActivationListener_ChangedMsg_single, list) : String.format(Messages.PartActivationListener_ChangedMsg_many, list)));
            if (this.editor.isDirty() && mainChanged) {
                msg = String.valueOf(msg) + System.getProperty("line.separator");
                msg = String.valueOf(msg) + System.getProperty("line.separator");
                msg = String.valueOf(msg) + Messages.PartActivationListener_ChangedMainWarning;
            } else if (this.editor.isDirty()) {
                HashSet<String> dirtyModels = new HashSet<String>(changedModels.size());
                for (Map.Entry<String, Boolean> entry : changedModels.entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    dirtyModels.add(entry.getKey());
                }
                if (!dirtyModels.isEmpty()) {
                    String dirtyList = this.getModelsListString(dirtyModels);
                    msg = String.valueOf(msg) + System.getProperty("line.separator");
                    msg = String.valueOf(msg) + System.getProperty("line.separator");
                    msg = String.valueOf(msg) + String.format(Messages.PartActivationListener_ChangedWarning, dirtyList);
                }
            }
            if (MessageDialog.openQuestion((Shell)new Shell(), (String)Messages.PartActivationListener_ChangedTitle, (String)msg)) {
                if (mainChanged) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbench wb = PlatformUI.getWorkbench();
                            IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
                            IEditorInput input = PartActivationListener.this.editor.getEditorInput();
                            page.closeEditor((IEditorPart)PartActivationListener.this.editor, false);
                            try {
                                IEditorDescriptor desc = wb.getEditorRegistry().getDefaultEditor(input.getName());
                                page.openEditor(input, desc.getId(), false);
                            }
                            catch (PartInitException e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                } else {
                    Command refreshCmd;
                    Object dom = this.editor.getAdapter(EditingDomain.class);
                    if (dom instanceof EditingDomain && (refreshCmd = this.getRefreshCommand((EditingDomain)dom, changedModels.keySet())).canExecute()) {
                        ((EditingDomain)dom).getCommandStack().execute(refreshCmd);
                    }
                }
            }
        }
    }

    private Command getRefreshCommand(final EditingDomain domain, final Set<String> changedModels) {
        AbstractCommand refreshCmd = new AbstractCommand(){
            private ModelSet modelSet;
            List<URI> urisToUpdate;

            public void execute() {
                for (URI uri : this.urisToUpdate) {
                    LoadingUtils.unloadResourcesFromModelSet((ModelSet)this.modelSet, (URI)uri, (boolean)false);
                    LoadingUtils.loadResourcesInModelSet((ModelSet)this.modelSet, (URI)uri);
                }
            }

            public void redo() {
                this.execute();
            }

            public void undo() {
                this.execute();
            }

            protected boolean prepare() {
                ResourceSet set = domain.getResourceSet();
                if (set instanceof ModelSet) {
                    this.modelSet = (ModelSet)set;
                    this.urisToUpdate = new ArrayList<URI>(changedModels.size());
                    for (String pathString : changedModels) {
                        IPath path = Path.fromPortableString((String)pathString);
                        this.urisToUpdate.add(URI.createPlatformResourceURI((String)path.toString(), (boolean)true));
                    }
                    return true;
                }
                return false;
            }
        };
        return refreshCmd;
    }

    /*
     * Unable to fully structure code
     */
    private String getModelsListString(Set<String> models) {
        list = new StringBuffer();
        it = models.iterator();
        if (models.size() != 1) ** GOTO lbl10
        return it.next();
lbl-1000:
        // 1 sources

        {
            model = it.next();
            list.append(System.getProperty("line.separator"));
            list.append(model);
lbl10:
            // 2 sources

            ** while (it.hasNext())
        }
lbl11:
        // 1 sources

        return list.toString();
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private static class ResourceModification {
        private IResourceDelta delta;
        private boolean conflict;

        public ResourceModification(IResourceDelta resourceDelta, boolean resourceConflicts) {
            this.delta = resourceDelta;
            this.conflict = resourceConflicts;
        }
    }
}

