/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.service.palette.AspectToolService;
import org.eclipse.papyrus.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.diagram.common.service.palette.IFeatureSetterAspectAction;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectUnspecifiedTypeCreationTool
extends UnspecifiedTypeCreationTool {
    protected List<IElementType> elementTypes;
    protected List<IAspectAction> postActions = new ArrayList<IAspectAction>();
    private static String ID_ASPECT_ACTION = "palette_aspect_actions";

    public AspectUnspecifiedTypeCreationTool(List<IElementType> elementTypes) {
        super(elementTypes);
        this.elementTypes = elementTypes;
    }

    protected void performCreation(int button) {
        this.antiScroll = true;
        boolean requiresPostAction = this.requiresPostAction();
        View eObject = (View)this.getTargetEditPart().getAdapter(View.class);
        DiagramEventBroker eventBroker = null;
        NotificationListener listener = null;
        if (requiresPostAction) {
            try {
                TransactionalEditingDomain domain = (TransactionalEditingDomain)EditorUtils.getServiceRegistry().getService(TransactionalEditingDomain.class);
                eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
                if (eventBroker == null) {
                    return;
                }
                listener = new NotificationListener(){

                    public void notifyChanged(Notification notification) {
                        Object newValue = notification.getNewValue();
                        EditPartViewer viewer = AspectUnspecifiedTypeCreationTool.this.getCurrentViewer();
                        if (viewer == null) {
                            EditPartViewer editPartViewer = viewer = AspectUnspecifiedTypeCreationTool.this.getTargetEditPart() != null ? AspectUnspecifiedTypeCreationTool.this.getTargetEditPart().getViewer() : null;
                        }
                        if (viewer != null) {
                            EditPart editPart = (EditPart)AspectUnspecifiedTypeCreationTool.this.getCurrentViewer().getEditPartRegistry().get(newValue);
                            for (IAspectAction action : AspectUnspecifiedTypeCreationTool.this.postActions) {
                                action.run(editPart);
                            }
                        } else {
                            Activator.log.error("Impossible to find the current viewer", null);
                        }
                    }
                };
                eventBroker.addNotificationListener((EObject)eObject, listener);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        EditPartViewer viewer = this.getCurrentViewer();
        Command c = this.getCurrentCommand();
        this.executeCurrentCommand();
        if (requiresPostAction && eventBroker != null) {
            eventBroker.removeNotificationListener((EObject)eObject, listener);
        }
        this.selectAddedObject(viewer, DiagramCommandStack.getReturnValues((Command)c));
        this.antiScroll = false;
    }

    protected boolean requiresPostAction() {
        return this.postActions.size() > 0;
    }

    protected void applyProperty(Object key, Object value) {
        if ("aspectActions".equals(key)) {
            if (value instanceof NodeList) {
                NodeList nodeList = (NodeList)value;
                int i = 0;
                while (i < nodeList.getLength()) {
                    org.w3c.dom.Node childNode = nodeList.item(i);
                    String childName = childNode.getNodeName();
                    if ("postAction".equals(childName)) {
                        IAspectActionProvider provider = AspectToolService.getInstance().getProvider(AspectToolService.getProviderId(childNode));
                        if (provider != null) {
                            IAspectAction action = provider.createAction(childNode);
                            this.postActions.add(action);
                        } else {
                            Activator.log.error("impossible to find factory with id: " + AspectToolService.getProviderId(childNode), null);
                        }
                    } else {
                        "preAction".equals(childName);
                    }
                    ++i;
                }
            }
            return;
        }
        super.applyProperty(key, value);
    }

    public List<IElementType> getElementTypes() {
        return this.elementTypes;
    }

    protected Request createTargetRequest() {
        CreateAspectUnspecifiedTypeRequest request = new CreateAspectUnspecifiedTypeRequest(this.getElementTypes(), this.getPreferencesHint());
        request.getExtendedData().put(ID_ASPECT_ACTION, this.postActions);
        return request;
    }

    public static List<IAspectAction> getAspectActions(Request request) {
        return request == null ? Collections.emptyList() : AspectUnspecifiedTypeCreationTool.getAspectActions(request.getExtendedData());
    }

    public static List<IAspectAction> getAspectActions(Map map) {
        return map == null ? Collections.emptyList() : map.get(ID_ASPECT_ACTION);
    }

    public String createPrePostActionRepresentation() {
        StringBuffer buffer = new StringBuffer();
        boolean flag = false;
        for (IAspectAction post : this.postActions) {
            if (!(post instanceof IFeatureSetterAspectAction)) continue;
            IFeatureSetterAspectAction featureSetter = (IFeatureSetterAspectAction)((Object)post);
            if (flag) {
                buffer.append("|");
                EStructuralFeature[] eStructuralFeatureArray = featureSetter.getAllImpactedFeatures();
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature f = eStructuralFeatureArray[n2];
                    EClass eClass = f.eClass();
                    buffer.append(eClass.getEPackage().getNsURI());
                    buffer.append(",");
                    buffer.append(eClass.getName());
                    buffer.append(",");
                    buffer.append(f.getName());
                    ++n2;
                }
            }
            flag = true;
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CreateAspectUnspecifiedTypeRequest
    extends CreateUnspecifiedTypeRequest {
        public CreateAspectUnspecifiedTypeRequest(List<IElementType> elementTypes, PreferencesHint preferencesHint) {
            super(elementTypes, preferencesHint);
        }

        protected void createRequests() {
            for (IElementType elementType : this.elementTypes) {
                CreateViewRequest.ViewDescriptor viewDescriptor;
                CreateViewRequest request = null;
                if (elementType instanceof INotationType) {
                    viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, ((INotationType)elementType).getSemanticHint(), this.getPreferencesHint());
                    request = new CreateViewRequest(viewDescriptor);
                } else if (elementType instanceof IHintedType) {
                    viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, this.getGraphicalHint((IHintedType)elementType), this.getPreferencesHint());
                    request = new CreateViewAndElementRequest((CreateViewAndElementRequest.ViewAndElementDescriptor)viewDescriptor);
                    request.setExtendedData(this.getExtendedData());
                } else {
                    viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, this.getPreferencesHint());
                    request = new CreateViewAndElementRequest((CreateViewAndElementRequest.ViewAndElementDescriptor)viewDescriptor);
                    request.setExtendedData(this.getExtendedData());
                }
                request.setType(this.getType());
                this.requests.put(elementType, request);
            }
        }

        protected String getGraphicalHint(IHintedType elementType) {
            String hint = elementType.getSemanticHint();
            return hint;
        }
    }
}

