/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.part.IPaletteDescription;
import org.eclipse.papyrus.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.diagram.common.service.XMLDefinitionPaletteFactory;
import org.eclipse.papyrus.diagram.common.service.XMLDefinitionPaletteParser;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LocalPaletteProvider
extends AbstractProvider
implements IPaletteProvider,
IPapyrusPaletteConstant {
    protected NodeList contributions = null;
    protected XMLDefinitionPaletteParser parser;

    public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
        this.parser = new XMLDefinitionPaletteParser(new XMLDefinitionPaletteFactory(root, predefinedEntries));
        int i = 0;
        while (i < this.contributions.getLength()) {
            Node node = this.contributions.item(i);
            if ("paletteDefinition".equals(node.getNodeName())) {
                this.parser.parsePaletteDefinition(node);
            }
            ++i;
        }
    }

    public void setContributions(IConfigurationElement configElement) {
        this.readXMLDocument(configElement.getAttribute("path"));
    }

    public void setContributions(IPaletteDescription description) {
        this.readXMLDocument(description.getContributions());
    }

    protected void readXMLDocument(Object contribution) {
        if (contribution instanceof String) {
            this.readXMLDocument((String)contribution);
        }
    }

    protected void readXMLDocument(String path) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStream inputStream = this.getXmlFile(path);
            if (inputStream == null) {
                throw new IOException("Impossible to load file: " + path);
            }
            Document document = documentBuilder.parse(inputStream);
            this.contributions = document.getChildNodes();
        }
        catch (ParserConfigurationException e) {
            Activator.log.error((Throwable)e);
            this.contributions = new EmptyNodeList();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
            this.contributions = new EmptyNodeList();
        }
        catch (SAXException e) {
            Activator.log.error((Throwable)e);
            this.contributions = new EmptyNodeList();
        }
    }

    public InputStream getXmlFile(String path) throws IOException {
        return new FileInputStream(Activator.getDefault().getStateLocation().append(path).toFile());
    }

    public boolean provides(IOperation operation) {
        return false;
    }

    public class EmptyNodeList
    implements NodeList {
        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }
    }
}

