/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service;

import java.util.Collection;
import java.util.List;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.diagram.common.service.AbstractXMLDefinitionPaletteFactory;
import org.eclipse.papyrus.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.diagram.common.service.palette.AspectToolService;
import org.eclipse.papyrus.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.diagram.common.service.palette.StereotypePostAction;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRequiredProfileFactory
extends AbstractXMLDefinitionPaletteFactory
implements IPapyrusPaletteConstant {
    protected final Collection<String> requiredProfiles;

    public XMLRequiredProfileFactory(Collection<String> requiredProfiles) {
        this.requiredProfiles = requiredProfiles;
    }

    @Override
    public void traverseContentNode(Node node) {
    }

    @Override
    public void traverseDrawerNode(Node node) {
    }

    @Override
    public void traverseToolEntryNode(Node node) {
    }

    @Override
    public void traverseStackNode(Node node) {
    }

    @Override
    public void traverseSeparatorNode(Node node) {
    }

    @Override
    public void traverseAspectToolEntryNode(Node node) {
        if (node.getChildNodes().getLength() > 0) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                String childName = childNode.getNodeName();
                if ("postAction".equals(childName)) {
                    IAspectActionProvider provider = AspectToolService.getInstance().getProvider(AspectToolService.getProviderId(childNode));
                    if (provider != null) {
                        IAspectAction action = provider.createAction(childNode);
                        if (action instanceof StereotypePostAction) {
                            List<String> stereotypesToApply = ((StereotypePostAction)action).getStereotypesToApply();
                            for (String stereotypeQN : stereotypesToApply) {
                                String profileName = PaletteUtil.findProfileNameFromStereotypeName(stereotypeQN);
                                this.requiredProfiles.add(profileName);
                            }
                        }
                    } else {
                        Activator.log.error("impossible to find factory with id: " + AspectToolService.getProviderId(childNode), null);
                    }
                }
                ++i;
            }
        }
    }
}

