/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service.palette;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.service.palette.GraphicalPostAction;
import org.eclipse.papyrus.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeStereotypeDisplayPostAction
extends GraphicalPostAction {
    protected String displayKind = "HorizontalStereo";
    protected String displayPlace = "Compartment";
    protected Combo directionCombo;
    protected Combo displayCombo;
    protected Combo placeCombo;
    protected static final String TEXT = "text";
    protected static final String ICON = "icon";
    protected static final String SHAPE = "shape";
    protected static final String TEXT_AND_ICON = "text and icon";
    protected static final List<String> DISPLAY_LIST = Arrays.asList("text", "icon", "text and icon", "shape");
    private static final String HORIZONTAL = "horizontal";
    private static final String VERTICAL = "vertical";
    protected static final List<String> DIRECTION_LIST = Arrays.asList("horizontal", "vertical");
    protected static final String COMMENT = "comment";
    protected static final String COMPARTMENT = "compartment";
    protected static final String BRACE = "brace";
    protected static final List<String> PLACE_LIST = Arrays.asList("comment", "compartment", "brace");
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            return;
        }
        Node node = configurationNode.getAttributes().getNamedItem("displayKind");
        if (node != null) {
            this.displayKind = node.getNodeValue();
        }
        if ((node = configurationNode.getAttributes().getNamedItem("displayPlace")) != null) {
            this.displayPlace = node.getNodeValue();
        }
    }

    @Override
    public void save(Node configurationNode) {
        if (configurationNode instanceof Element) {
            ((Element)configurationNode).setAttribute("displayKind", this.displayKind);
            ((Element)configurationNode).setAttribute("displayPlace", this.displayPlace);
        } else {
            Activator.log.error("configuration node is not an Element", null);
        }
    }

    @Override
    public void run(final EditPart editPart) {
        final CompositeCommand compositeCommand = new CompositeCommand("Modify Stereotype Display");
        final EModelElement view = (EModelElement)((GraphicalEditPart)editPart).getModel();
        final TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        try {
            editingDomain.runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String stereotypetoDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)view);
                            final RecordingCommand command = AppliedStereotypeHelper.getAppliedStereotypeToDisplayCommand((TransactionalEditingDomain)editingDomain, (EModelElement)view, (String)stereotypetoDisplay, (String)(this).ChangeStereotypeDisplayPostAction.this.displayKind);
                            compositeCommand.compose((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)command));
                            compositeCommand.reduce();
                            if (compositeCommand.canExecute()) {
                                boolean isActivating = true;
                                Map<String, Boolean> options = null;
                                EditPartViewer viewer = editPart.getViewer();
                                if (viewer instanceof DiagramGraphicalViewer) {
                                    isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
                                }
                                if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)editPart), (boolean)false, (boolean)false)) {
                                    options = Collections.singletonMap("unprotected", Boolean.TRUE);
                                }
                                AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)editPart).getEditingDomain(), "", options){

                                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                        editingDomain.getCommandStack().execute((Command)command);
                                        return Status.OK_STATUS;
                                    }
                                };
                                try {
                                    operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                                }
                                catch (ExecutionException e) {
                                    Activator.log.error((Throwable)e);
                                }
                            } else {
                                Activator.log.error("Impossible to execute graphical post action " + (this).ChangeStereotypeDisplayPostAction.this.propertiesToUpdate, null);
                            }
                        }
                    });
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        Composite mainComposite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)layout);
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText("Customize stereotype display");
        GridData data = new GridData(4, 0x1000000, true, false, 2, 1);
        titleLabel.setLayoutData((Object)data);
        Label displayLabel = new Label(mainComposite, 0);
        displayLabel.setText("Stereotype Display:");
        this.displayCombo = new Combo(mainComposite, 2056);
        this.displayCombo.setItems(DISPLAY_LIST.toArray(new String[0]));
        data = new GridData(4, 0x1000000, true, false);
        this.displayCombo.setLayoutData((Object)data);
        this.displayCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChangeStereotypeDisplayPostAction.this.updateDisplayKindValue();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label directionLabel = new Label(mainComposite, 0);
        directionLabel.setText("Text alignement:");
        this.directionCombo = new Combo(mainComposite, 2056);
        this.directionCombo.setItems(DIRECTION_LIST.toArray(new String[0]));
        this.directionCombo.setLayoutData((Object)data);
        this.directionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChangeStereotypeDisplayPostAction.this.updateDisplayKindValue();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label placeLabel = new Label(mainComposite, 0);
        placeLabel.setText("Display place:");
        this.placeCombo = new Combo(mainComposite, 2056);
        this.placeCombo.add("Comment");
        this.placeCombo.add("Compartment");
        this.placeCombo.add("With brace");
        this.placeCombo.setLayoutData((Object)data);
        this.placeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChangeStereotypeDisplayPostAction.this.updateDisplayPlaceValue();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateCombos();
        return mainComposite;
    }

    protected void updateDisplayPlaceValue() {
        int placeIndex = this.placeCombo.getSelectionIndex();
        String place = PLACE_LIST.get(placeIndex >= 0 ? placeIndex : 0);
        this.displayPlace = BRACE.equals(place) ? "With brace" : (COMMENT.equals(place) ? "Comment" : "Compartment");
        this.updateCombos();
    }

    protected void updateDisplayKindValue() {
        int displayIndex = this.displayCombo.getSelectionIndex();
        String display = DISPLAY_LIST.get(displayIndex >= 0 ? displayIndex : 0);
        int directionIndex = this.directionCombo.getSelectionIndex();
        String direction = DIRECTION_LIST.get(directionIndex >= 0 ? directionIndex : 0);
        this.displayKind = ICON.equals(display) ? "IconStereotype" : (TEXT_AND_ICON.equals(display) ? "TextIconStereotype" : (SHAPE.equals(display) ? "ImageStereotype" : (VERTICAL.equals(direction) ? "VerticalStereo" : "HorizontalStereo")));
        this.updateCombos();
    }

    protected void updateCombos() {
        if ("TextIconStereotype".equals(this.displayKind)) {
            this.displayCombo.select(DISPLAY_LIST.indexOf(TEXT_AND_ICON));
            this.directionCombo.select(DIRECTION_LIST.indexOf(HORIZONTAL));
            this.directionCombo.setEnabled(false);
        } else if ("IconStereotype".equals(this.displayKind)) {
            this.displayCombo.select(DISPLAY_LIST.indexOf(ICON));
            this.directionCombo.select(DIRECTION_LIST.indexOf(HORIZONTAL));
            this.directionCombo.setEnabled(false);
        } else if ("ImageStereotype".equals(this.displayKind)) {
            this.displayCombo.select(DISPLAY_LIST.indexOf(SHAPE));
            this.directionCombo.select(DIRECTION_LIST.indexOf(HORIZONTAL));
            this.directionCombo.setEnabled(false);
        } else if ("VerticalStereo".equals(this.displayKind)) {
            this.displayCombo.select(DISPLAY_LIST.indexOf(TEXT));
            this.directionCombo.select(DIRECTION_LIST.indexOf(VERTICAL));
            this.directionCombo.setEnabled(true);
        } else {
            this.displayCombo.select(DISPLAY_LIST.indexOf(TEXT));
            this.directionCombo.select(DIRECTION_LIST.indexOf(HORIZONTAL));
            this.directionCombo.setEnabled(true);
        }
        if ("Comment".equals(this.displayPlace)) {
            this.placeCombo.select(PLACE_LIST.indexOf(COMMENT));
        } else if ("With brace".equals(this.displayPlace)) {
            this.placeCombo.select(PLACE_LIST.indexOf(BRACE));
        } else {
            this.placeCombo.select(PLACE_LIST.indexOf(COMPARTMENT));
        }
    }
}

