/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.service.palette;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.diagram.common.service.palette.ModelPostAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalPostAction
extends ModelPostAction {
    protected Map<String, Object> propertiesToUpdate = new HashMap<String, Object>();
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            return;
        }
        NodeList childNodes = configurationNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node featureNode = childNodes.item(i);
            if ("feature".equals(featureNode.getNodeName())) {
                Node nameNode = childNodes.item(i).getAttributes().getNamedItem("name");
                Node valueNode = childNodes.item(i).getAttributes().getNamedItem("value");
                if (nameNode != null && valueNode != null) {
                    this.propertiesToUpdate.put(nameNode.getNodeValue(), valueNode.getNodeValue());
                } else {
                    Activator.log.error("Impossible to parse the configuration node for graphical post action", null);
                }
            }
            ++i;
        }
    }

    @Override
    public void run(EditPart editPart) {
        final CompositeCommand compositeCommand = new CompositeCommand("Modify Graphic");
        View objectToEdit = (View)editPart.getModel();
        for (String featureName : this.propertiesToUpdate.keySet()) {
            EStructuralFeature feature = objectToEdit.eClass().getEStructuralFeature(featureName);
            if (feature == null) {
                Activator.log.error("Impossible to find the feature " + featureName + " for element " + objectToEdit, null);
                return;
            }
            SetRequest request = new SetRequest((EObject)objectToEdit, feature, this.getValue(feature, this.propertiesToUpdate.get(featureName)));
            compositeCommand.compose((IUndoableOperation)new SetValueCommand(request));
        }
        compositeCommand.reduce();
        if (compositeCommand.canExecute()) {
            boolean isActivating = true;
            Map<String, Boolean> options = null;
            EditPartViewer viewer = editPart.getViewer();
            if (viewer instanceof DiagramGraphicalViewer) {
                isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
            }
            if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)editPart), (boolean)false, (boolean)false)) {
                options = Collections.singletonMap("unprotected", Boolean.TRUE);
            }
            AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)editPart).getEditingDomain(), "", options){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    compositeCommand.execute(monitor, info);
                    return Status.OK_STATUS;
                }
            };
            try {
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            Activator.log.error("Impossible to execute graphical post action " + this.propertiesToUpdate, null);
        }
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText("Configuration of graphical post action : ");
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        return composite;
    }

    @Override
    public void save(Node parentNode) {
    }
}

